<?php
$genMsg = $password = $username = $fullname = $email = $getMsg = $phone = $password = $coupon = $country = $role =$plantype="";


/*if (isset($_POST['login'])) {
  
    if (empty($_POST['username'])) {
        $status = "error";
        $message = "Enter your username";
        $genMsg = sendResponse($status, $message);
    } else if (empty($_POST['password'])) {
        $status = "error";
        $message = "Enter your password";
        $genMsg = sendResponse($status, $message);
    } else {
        $username = $_POST['username'];
        $password = $_POST['password'];

        // Hash the password using sha1

        // ✅ Get stored password hash from DB
    $sql = $link->prepare("SELECT password FROM users WHERE username=? LIMIT 1");
    $sql->bind_param("s", $username);
    $sql->execute();
    $result = $sql->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        $hashedPassword = $row['password'];
    }

        // Prepare the SQL statement to check the user
        $sql = $link->prepare("SELECT * FROM users WHERE username=? OR email=?");
        $sql->bind_param("ss", $username, $username);
        $sql->execute();
        $result = $sql->get_result();
        $numrow = $result->num_rows;

        if ($numrow == 0) {
            $status = "error";
            $message = "Incorrect username or password";
            $genMsg = sendResponse($status, $message);
        } else {
            $row = $result->fetch_assoc();
            $hashedPassword = $row['password'];
            $username = $row['username'];
            $role = $row['role'];
            $accountStatus = $row['status']; // Changed variable name to avoid conflict with status used for response
            $time = $row['time'];

            if (!password_verify($password, $hashedPassword)) {
                $status = "error";
                $message = "Incorrect username or password";
                $genMsg = sendResponse($status, $message);
            } else if ($accountStatus == "suspended" && $role != "admin") {
                $status = "error";
                $message = "Your account has been suspended";
                $genMsg = sendResponse($status, $message);
            } else {
                // Perform daily login bonus update
                $date = date('Y-m-d');
                $dateTime = date('Y-m-d H:i:s');

                $sql = $link->prepare("SELECT * FROM dailylogin WHERE username=? AND SUBSTRING(date,1,10) =?");
                $sql->bind_param("ss", $username, $date);
                $sql->execute();
                $result = $sql->get_result();
                $numrow = $result->num_rows;

                if ($numrow == 0) {
                    
                    $sql = $link->prepare("SELECT role FROM users WHERE username = ?");
$sql->bind_param("s", $username);
$sql->execute();
$sql->bind_result($role);
$sql->fetch();
$sql->close();
                    
                    // Fetch the user's plan type from users table
$sql = $link->prepare("SELECT plantype FROM users WHERE username = ? LIMIT 1");
$sql->bind_param("s", $username);
$sql->execute();
$result = $sql->get_result();
if ($row = $result->fetch_assoc()) {
    $plantype = $row['plantype'];  // store user's plan type
} else {
    $plantype = ''; // fallback
}
$result->free();
$sql->close();

// Fetch daily login bonus from earningstructure table based on user's plan type
$sql = $link->prepare("SELECT dailylogin FROM earningstructure WHERE type = ? LIMIT 1");
$sql->bind_param("s", $plantype);
$sql->execute();
$result = $sql->get_result();

if ($row = $result->fetch_assoc()) {
    $dailyLogin = $row['dailylogin'];
} else {
    $dailyLogin = 0; // fallback if plan type not found
}

$result->free();
$sql->close();

                    // Update user's funds
                    $sql = $link->prepare("UPDATE users SET referralfunds=referralfunds + ? WHERE username=?");
                    $sql->bind_param("ds", $dailyLogin, $username); // Changed "ss" to "ds" since funds should be a decimal value
                    if ($sql->execute()) {
                        $sql = $link->prepare("INSERT INTO dailylogin(username,amount,date) VALUES(?,?,?)");
                        $sql->bind_param("sds", $username, $dailyLogin, $dateTime);
                        $sql->execute();

                        $type = "Daily Login";
                        $sql = $link->prepare("INSERT INTO userearnings(username, type, amount, time, date) VALUES(?,?,?,?,?)");
                        $sql->bind_param("sssss", $username, $type, $dailyLogin, $time, $dateTime);
                        $sql->execute();
                    }
                }

                // If everything is successful
                $status = "success";
                $message = "Login successful";
                $genMsg = sendResponse($status, $message);
            }
        }
    }

    
                session_regenerate_id();
                $_SESSION['username'] = $username;
                $_SESSION['role'] = $role;
                session_write_close();
                if ($role == "user" || $role == "vendor") {
                    header("locati*/
                    
                    
if (isset($_POST['login'])) {
  
    if (empty($_POST['username'])) {
        $status = "error";
        $message = "Enter your username";
        $genMsg = sendResponse($status, $message);
    } else if (empty($_POST['password'])) {
        $status = "error";
        $message = "Enter your password";
        $genMsg = sendResponse($status, $message);
    } else {
        $username = $_POST['username'];
        $password = $_POST['password'];

        // ✅ Get stored user
        $sql = $link->prepare("SELECT * FROM users WHERE username=? OR email=? LIMIT 1");
        $sql->bind_param("ss", $username, $username);
        $sql->execute();
        $result = $sql->get_result();

        if ($result->num_rows === 0) {
            $status = "error";
            $message = "Incorrect username or password";
            $genMsg = sendResponse($status, $message);
        } else {
            $row = $result->fetch_assoc();
            $hashedPassword = $row['password'];
            $username       = $row['username'];
            $role           = $row['role'];
            $accountStatus  = $row['status'];
            $time           = $row['time'];

            // ✅ Verify password properly
            if (!password_verify($password, $hashedPassword)) {
                $status = "error";
                $message = "Incorrect username or password";
                $genMsg = sendResponse($status, $message);
            } else if ($accountStatus == "suspended" && $role != "admin") {
                $status = "error";
                $message = "Your account has been suspended";
                $genMsg = sendResponse($status, $message);
            } else {
                // ✅ Daily login bonus check
                $date = date('Y-m-d');
                $dateTime = date('Y-m-d H:i:s');

                $sql = $link->prepare("SELECT * FROM dailylogin WHERE username=? AND SUBSTRING(date,1,10)=?");
                $sql->bind_param("ss", $username, $date);
                $sql->execute();
                $result = $sql->get_result();

                if ($result->num_rows == 0) {
                    // Get user plan
                    $sql = $link->prepare("SELECT plantype FROM users WHERE username=? LIMIT 1");
                    $sql->bind_param("s", $username);
                    $sql->execute();
                    $r = $sql->get_result()->fetch_assoc();
                    $plantype = $r['plantype'] ?? '';

                    // Get bonus from earningstructure
                    $sql = $link->prepare("SELECT dailylogin FROM earningstructure WHERE type=? LIMIT 1");
                    $sql->bind_param("s", $plantype);
                    $sql->execute();
                    $r = $sql->get_result()->fetch_assoc();
                    $dailyLogin = $r['dailylogin'] ?? 0;

                    // Update user funds
                    $sql = $link->prepare("UPDATE users SET referralfunds=referralfunds+? WHERE username=?");
                    $sql->bind_param("ds", $dailyLogin, $username);
                    if ($sql->execute()) {
                        $sql = $link->prepare("INSERT INTO dailylogin(username,amount,date) VALUES(?,?,?)");
                        $sql->bind_param("sds", $username, $dailyLogin, $dateTime);
                        $sql->execute();

                        $type = "Daily Login";
                        $sql = $link->prepare("INSERT INTO userearnings(username,type,amount,time,date) VALUES(?,?,?,?,?)");
                        $sql->bind_param("sssss", $username, $type, $dailyLogin, $time, $dateTime);
                        $sql->execute();
                    }
                }

                // ✅ Success
                $status = "success";
                $message = "Login successful";
                $genMsg = sendResponse($status, $message);

                session_regenerate_id();
                $_SESSION['username'] = $username;
                $_SESSION['role']     = $role;
                session_write_close();

                if ($role == "user" || $role == "vendor") {
                    header("location:dash");
                } else if ($role == "assistant") {
                    header("location:assistant/account.php");
                } else if ($role == "admin") {
                    header("location:admin/dashboard.php");
                }
                exit;
            }
        }
    }
}      
   




if (isset($_POST['signup'])) {
    
    // Validate input
    if (!empty($_POST['fullname'])) {
        $fullname = $_POST['fullname'];
    }
    if (!empty($_POST['username'])) {
        $username = $_POST['username'];
    }
    if (!empty($_POST['email'])) {
        $email = $_POST['email'];
    }
    if (!empty($_POST['phoneNumber'])) {
        $phone = $_POST['phoneNumber'];
    }
    if (!empty($_POST['password'])) {
        $password = $_POST['password'];
    }
    if (!empty($_POST['coupon'])) {
        $coupon = $_POST['coupon'];
    }
    if (!empty($_POST['countryname'])) {
        $countryname = $_POST['countryname'];
    }
    if (!empty($_POST['plantype'])) {
        $plantype = $_POST['plantype'];
    }
    if (!empty($_POST['refUsername'])) {
        $refUsername = $_POST['refUsername'];
    }

    // Error handling
    if (empty($fullname)) {
        $status = "error";
        $message = "Enter your fullname";
        $genMsg = sendResponse($status, $message);
    }
    if (empty($username)) {
        $status = "error";
        $message = "Enter a username";
        $genMsg = sendResponse($status, $message);
    } else if (strlen($username) > 20) {
        $status = "error";
        $message = "Username should be less than 20 characters";
        $genMsg = sendResponse($status, $message);
    } else if (empty($email)) {
        $status = "error";
        $message = "Enter your email address";
        $genMsg = sendResponse($status, $message);
    } else if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $status = "error";
        $message = "Enter a valid email address";
        $genMsg = sendResponse($status, $message);
    } else if (empty($phone)) {
        $status = "error";
        $message = "Enter your phone number";
        $genMsg = sendResponse($status, $message);
    } else if (empty($coupon)) {
        $status = "error";
        $message = "Enter coupon code";
        $genMsg = sendResponse($status, $message);
    } else if (empty($countryname)) {
        $status = "error";
        $message = "Select a country";
        $genMsg = sendResponse($status, $message);
    } else if (empty($plantype)) {
        $status = "error";
        $message = "Select a plan";
        $genMsg = sendResponse($status, $message);
    } else if (empty($password)) {
        $status = "error";
        $message = "Enter a password";
        $genMsg = sendResponse($status, $message);
    } else if (strlen($password) < 8) {
        $status = "error";
        $message = "Password must be at least 8 characters";
        $genMsg = sendResponse($status, $message);
    } else {
        $fullname=filter_string($_POST['fullname']);
        $username = filter_string($_POST['username']);
        $email = filter_string($_POST['email']);
        $phoneNumber = filter_string($_POST['phoneNumber']);
        $coupon = filter_string($_POST['coupon']);
        $countryname = filter_string($_POST['countryname']);
        $password = filter_string($_POST['password']);
        $plantype = filter_string($_POST['plantype']);

// Check for existing users and coupons

// Check if the username already exists
$sql_user = $link->prepare("SELECT * FROM users WHERE username=?");
$sql_user->bind_param("s", $username);
$sql_user->execute();
$result_user = $sql_user->get_result();
$numrow_user = $result_user->num_rows;

// Check if the email already exists
$sql_email = $link->prepare("SELECT * FROM users WHERE email=?");
$sql_email->bind_param("s", $email);
$sql_email->execute();
$result_email = $sql_email->get_result();
$numrow_email = $result_email->num_rows;

// Check if the phone number already exists
$sql_phone = $link->prepare("SELECT * FROM users WHERE phone=?");
$sql_phone->bind_param("s", $phone);
$sql_phone->execute();
$result_phone = $sql_phone->get_result();
$numrow_phone = $result_phone->num_rows;

// Check if the coupon exists
$sql_coupon = $link->prepare("SELECT * FROM coupons WHERE coupon=?");
$sql_coupon->bind_param("s", $coupon);
$sql_coupon->execute();
$result_coupon = $sql_coupon->get_result();
$numrow_coupon = $result_coupon->num_rows;

// Check if the coupon is active
$sql_couponUsed = $link->prepare("SELECT * FROM coupons WHERE coupon=? AND status='active'");
$sql_couponUsed->bind_param("s", $coupon);
$sql_couponUsed->execute();
$result_couponUsed = $sql_couponUsed->get_result();
$numrow_couponUsed = $result_couponUsed->num_rows;

// Check if the coupon code and country are valid together
$sql_country = $link->prepare("SELECT * FROM coupons WHERE coupon=? AND countryname=?");
$sql_country->bind_param("ss", $coupon, $countryname);
$sql_country->execute();
$result_country = $sql_country->get_result();
$numrow_couponCountry = $result_country->num_rows;

// Check if the coupon code and plantype are valid together
$sql_type = $link->prepare("SELECT * FROM coupons WHERE coupon=? AND type=?");
$sql_type->bind_param("ss", $coupon, $plantype);  // Use plantype from the form
$sql_type->execute();
$result_type = $sql_type->get_result();
$numrow_coupontype = $result_type->num_rows;

if ($numrow_user > 0) {
    $status = "error";
    $message = "Username already exists";
    $genMsg = sendResponse($status, $message);
} else if ($numrow_email > 0) {
    $status = "error";
    $message = "Email already exists";
    $genMsg = sendResponse($status, $message);
} else if ($numrow_phone > 0) {
    $status = "error";
    $message = "Phone number already in use";
    $genMsg = sendResponse($status, $message);
} else if ($numrow_coupon == 0) {
    $status = "error";
    $message = "Invalid coupon";
    $genMsg = sendResponse($status, $message);
} else if ($numrow_couponUsed == 0) {
    $status = "error";
    $message = "Coupon has already been used";
    $genMsg = sendResponse($status, $message);
} else if ($numrow_couponCountry == 0) {
    $status = "error";
    $message = "Coupon code is invalid for the selected country";
    $genMsg = sendResponse($status, $message);   
} else if ($numrow_coupontype == 0) {
    $status = "error";
    $message = "Coupon code is invalid for the selected plan";
    $genMsg = sendResponse($status, $message);
} else {
    /*$hashedPassword = sha1($password);*/
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    $numrow_refUser = 1;
    $addRef = true;

           if ($numrow_refUser == 0) {
    $status = "error";
    $message = "Invalid referral";
    $genMsg = sendResponse($status, $message);
} else {

    // Fetch the indirect referral bonus from the earning structure
    // ✅ $plantype comes from user input
$plantype = $_POST['plantype'] ?? '';

// Fetch bonuses for that plan type
$sql = $link->prepare("SELECT refbonus, indref, thirdindref, welbonus 
                       FROM earningstructure 
                       WHERE type = ? LIMIT 1");
$sql->bind_param("s", $plantype);
$sql->execute();
$result = $sql->get_result();

if ($row = $result->fetch_assoc()) {
    $refBonus = $row['refbonus'];
    $indRefBonus = $row['indref'];
    $secondIndRefBonus = $row['thirdindref'];
    $welbonus = $row['welbonus'];
} else {
    // If no row found for this plan
    $refBonus = $indRefBonus = $secondIndRefBonus = $welbonus = 0;
}

$result->free();
$sql->close();

    if ($addRef) {
        // Add the direct referral
        $sql = $link->prepare("INSERT INTO referrals (username, referral, earnings, date) VALUES (?, ?, ?, ?)");
        $sql->bind_param("ssss", $username, $refUsername, $refBonus, $dateTime);
        $sql->execute();

        // Update referralfunds for the direct referrer
        $sql = $link->prepare("UPDATE users SET referralfunds = referralfunds + ?, totalrefearnings = totalrefearnings + ? WHERE username = ?");
        $sql->bind_param("sss", $refBonus, $refBonus, $refUsername);
        $sql->execute();

        // Log earnings for the direct referrer
        $type = "Direct Affiliate Bonus";
        $sql = $link->prepare("INSERT INTO userearnings (username, type, amount, time, date) VALUES (?, ?, ?, ?, ?)");
        $sql->bind_param("sssss", $refUsername, $type, $refBonus, $time, $dateTime);
        $sql->execute();

        // Check if the direct referrer has an indirect referrer
        $sql = $link->prepare("SELECT referral FROM referrals WHERE username = ?");
        $sql->bind_param("s", $refUsername);
        $sql->execute();
        $result = $sql->get_result();
        $numrow_indirectRef = $result->num_rows;

        if ($numrow_indirectRef == 1) {
            $row = $result->fetch_assoc();
            $indirectReferrer = $row['referral'];

            // Begin transaction (assuming InnoDB tables)
            $link->begin_transaction();

            try {
                // Update referralfunds for the first-level indirect referrer
                $sql = $link->prepare("UPDATE users SET referralfunds = referralfunds + ? WHERE username = ?");
                $sql->bind_param("ss", $indRefBonus, $indirectReferrer);
                $sql->execute();

                $sql = $link->prepare("UPDATE users SET indref = indref + ?, totalrefearnings = totalrefearnings + ? WHERE username = ?");
                $sql->bind_param("sss", $indRefBonus, $indRefBonus, $indirectReferrer);
                $sql->execute();

                $sql = $link->prepare("INSERT INTO indirectreferrals (username, indirectusername, referral, date) VALUES (?, ?, ?, ?)");
                $sql->bind_param("ssss", $username, $indirectReferrer, $refUsername, $dateTime);
                $sql->execute();

                // Log earnings for the first-level indirect referrer
                $type = "1st Indirect Affiliate Bonus";
                $sql = $link->prepare("INSERT INTO userearnings (username, type, amount, time, date) VALUES (?, ?, ?, ?, ?)");
                $sql->bind_param("sssss", $indirectReferrer, $type, $indRefBonus, $time, $dateTime);
                $sql->execute();

                // Commit the transaction
                $link->commit();
            } catch (Exception $e) {
                // Rollback the transaction if an error occurred
                $link->rollback();
                echo "Error: " . $e->getMessage();
            }

            // Check if the first-level indirect referrer has a second-level indirect referrer
            $sql = $link->prepare("SELECT referral FROM referrals WHERE username = ?");
            $sql->bind_param("s", $indirectReferrer);
            $sql->execute();
            $result = $sql->get_result();
            $numrow_secondIndRefUser = $result->num_rows;

            if ($numrow_secondIndRefUser == 1) {
                $row = $result->fetch_assoc();
                $secondIndReferrer = $row['referral'];

                // Begin transaction (assuming InnoDB tables)
                $link->begin_transaction();

                try {
                    // Update referralfunds for the second-level indirect referrer
                    $sql = $link->prepare("UPDATE users SET referralfunds = referralfunds + ? WHERE username = ?");
                    $sql->bind_param("ss", $secondIndRefBonus, $secondIndReferrer);
                    $sql->execute();

                    $sql = $link->prepare("UPDATE users SET thirdindref = thirdindref + ?, totalrefearnings = totalrefearnings + ? WHERE username = ?");
                    $sql->bind_param("sss", $secondIndRefBonus, $secondIndRefBonus, $secondIndReferrer);
                    $sql->execute();

                    // Insert the second-level indirect referral record
                    $sql = $link->prepare("INSERT INTO indirectreferrals (username, indirectusername, referral, date) VALUES (?, ?, ?, ?)");
                    $sql->bind_param("ssss", $username, $secondIndReferrer, $refUsername, $dateTime);
                    $sql->execute();

                    // Log earnings for the second-level indirect referrer
                    $type = "2nd Indirect Affiliate Bonus";
                    $sql = $link->prepare("INSERT INTO userearnings (username, type, amount, time, date) VALUES (?, ?, ?, ?, ?)");
                    $sql->bind_param("sssss", $secondIndReferrer, $type, $secondIndRefBonus, $time, $dateTime);
                    $sql->execute();

                    // Commit the transaction
                    $link->commit();
                } catch (Exception $e) {
                    // Rollback the transaction if an error occurred
                    $link->rollback();
                    echo "Error: " . $e->getMessage();
                }
            }
        }
    }
}



                // Store user data
                $sql = $link->prepare("INSERT INTO users (fullname, username, email, phone, password, date, coupon, countryname, plantype, time) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $sql->bind_param("ssssssssss", $fullname, $username, $email, $phone, $hashedPassword, $dateTime, $coupon, $countryname, $plantype, $time);

                if ($sql->execute()) {
                    $sql = $link->prepare("UPDATE coupons SET status='used' WHERE coupon=?");
                    $sql->bind_param("s", $coupon);
                    $sql->execute();

                    $message = "Welcome";
                    $subject = "Welcome to $sitename You earned cashback from welcome bonus data <p class='text-success'> + $welbonus </p>";
                    $type = "welcomeMail";
                    sendMail($email, $fullname, $message, $subject, $type);

                    $sql = $link->prepare("UPDATE users SET referralfunds=referralfunds + ? WHERE username=?");
                    $sql->bind_param("ss", $welbonus, $username);
                    $sql->execute();

                    $type = "Cashback Bonus";
                    $sql = $link->prepare("INSERT INTO userearnings (username, type, amount, time, date) VALUES (?, ?, ?, ?, ?)");
                    $sql->bind_param("sssss", $username, $type, $welbonus, $time, $dateTime);
                    $sql->execute();

                    $status = "success";
                    $message = "Registration successful";
                    $genMsg = sendResponse($status, $message);
                    echo "<script>setTimeout(()=>location.href='$stream/login.php', 3000);</script>";
                } else {
                    $status = "error";
                    $message = "Something went wrong creating account";
                    $genMsg = sendResponse($status, $message);
                }
            }
        }
    }





    


    

if(isset($_POST['forgotPsw'])){
    if(empty($_POST['email'])){
        $status="error";
        $message="Enter your email address"; 
        $genMsg=sendResponse($status, $message);
    }
    else{
        $email=filter_string($_POST['email']);

        $sql=$link->prepare("SELECT * FROM users WHERE email=?");
        $sql->bind_param("s", $email);
        $sql->execute();
        $result=$sql->get_result();
        $numrow=$result->num_rows;
        $row=$result->fetch_assoc();
        if($numrow == 1){
            $fullname=$row['fullname'];
            $token=get_rand_alphanumeric(20);
            $sql=$link->prepare("DELETE FROM otp WHERE email=?");
            $sql->bind_param("s", $email);
            if($sql->execute()){
                $sql=$link->prepare("INSERT INTO otp(email, otp, date) VALUES(?,?,?)");
                $sql->bind_param("sss", $email, $token, $dateTime);
                $sql->execute();

                $subject="Password Reset";
                $message=array("fullname" => $fullname, "pswToken" => $token);
                $type="forgotPsw";

                $mail=sendMail($email, $fullname, $message, $subject, $type);
                $mailStatus=$mail['status'];
                $mailMessage=$mail['message'];
                if($mailStatus == "success"){
                    $status="success";
                    $message="Password reset link sent successfully. Please check your email and follow the procedures"; 
                    $genMsg=sendResponse($status, $message);
                }
                else{
                    $status="success";
                    $message="$sitelink/reset-password.php?tkn=$token"; 
                    $genMsg=sendResponse($status, $message);
                }
            }
            else{
                $status="error";
                $message="Something went wrong"; 
                $genMsg=sendResponse($status, $message);
            }
        }
        else{
            $status="error";
            $message="Invalid email address"; 
            $genMsg=sendResponse($status, $message);
        }
    }
}


if (isset($_POST['resetPsw'])) {
    if (empty($_POST['password'])) {
        $status = "error";
        $message = "Enter your new password";
        $genMsg = sendResponse($status, $message);
    } else if (strlen($_POST['password']) < 8) {
        $status = "error";
        $message = "Password must be at least 8 characters";
        $genMsg = sendResponse($status, $message);
    } else if (empty($_POST['confirmPsw'])) {
        $status = "error";
        $message = "Retype your new password";
        $genMsg = sendResponse($status, $message);
    } else if ($_POST['password'] != $_POST['confirmPsw']) {
        $status = "error";
        $message = "Passwords do not match";
        $genMsg = sendResponse($status, $message);
    } else {
        $password = filter_string($_POST['password']);
        $password = sha1($password);
        $password = password_hash($password, PASSWORD_DEFAULT);
        $email = filter_string($_SESSION['forgotEmail']);

        $sql = $link->prepare("UPDATE users SET password=? WHERE email=?");
        $sql->bind_param("ss", $password, $email);
        if ($sql->execute()) {
            $sql = $link->prepare("DELETE FROM otp WHERE email=?");
            $sql->bind_param("s", $email);
            $sql->execute();

            header("location:login.php");
        } else {
            $status = "error";
            $message = "Failed to update the password";
            $genMsg = sendResponse($status, $message);
        }
    }
}
 


?>

 
