<?php
$genMsg = $question = $id = $correct_answer = "";
$answers = [];
$amount_a = $amount_b = "";

if (isset($_POST['addquestion'])) {
    // Validate Question
    if (!empty($_POST['question'])) {
        $question = filter_string($_POST['question']);
    } else {
        $status = "error";
        $message = "Enter question";
        $genMsg = sendResponse($status, $message);
    }

    // Validate Correct Answer
    if (!empty($_POST['correct_answer'])) {
        $correct_answer = filter_string($_POST['correct_answer']);
    } else {
        $status = "error";
        $message = "Enter correct answer";
        $genMsg = sendResponse($status, $message);
    }

    // Validate Multiple Answers
    if (!empty($_POST['answers'])) {
        $answers = $_POST['answers'];
    } else {
        $status = "error";
        $message = "Enter at least one answer";
        $genMsg = sendResponse($status, $message);
    }

    // Validate Plan Amounts
    if (!empty($_POST['amount_a'])) {
        $amount_a = filter_string($_POST['amount_a']);
    } else {
        $amount_a = 0;
    }

    if (!empty($_POST['amount_b'])) {
        $amount_b = filter_string($_POST['amount_b']);
    } else {
        $amount_b = 0;
    }

    // Proceed if no errors
    if (empty($genMsg)) {
        $dateTime = date('Y-m-d H:i:s');

        // Get up to 3 answers safely
        $answer1 = isset($answers[0]) ? filter_string($answers[0]) : "";
        $answer2 = isset($answers[1]) ? filter_string($answers[1]) : "";
        $answer3 = isset($answers[2]) ? filter_string($answers[2]) : "";
        $answer4 = isset($answers[3]) ? filter_string($answers[3]) : "";

        // Insert into questions table
        $sql = $link->prepare("INSERT INTO quiz (question, answer1, answer2, answer3, correct_answer, amount_a, amount_b) 
                               VALUES (?, ?, ?, ?, ?, ?, ?)");
        $sql->bind_param("ssssidd", $question, $answer1, $answer2, $answer3, $correct_answer, $amount_a, $amount_b);

        if ($sql->execute()) {
            $status = "success";
            $message = "Question uploaded successfully";
            $genMsg = sendResponse($status, $message);
        } else {
            $status = "error";
            $message = "Failed to upload question";
            $genMsg = sendResponse($status, $message);
        }
    }
}

// Handle delete request
if (isset($_POST['deleteQuiz'])) {
    $id = intval($_POST['id']);

    $sql = $link->prepare("DELETE FROM quiz WHERE id = ?");
    $sql->bind_param("i", $id);

    if ($sql->execute()) {
        $status = "success";
        $message = "Quiz deleted successfully";
        $genMsg = sendResponse($status, $message);
    } else {
        $status = "error";
        $message = "Failed to delete quiz";
        $genMsg = sendResponse($status, $message);
    }
}
?>