<?php
$title = $desc = $titleErr = $descErr = $videoMsg = $postMsg = $video = $videoErr = $url = $urlErr = $amount = $amountErr = $b_amount = $b_amountErr = $spostMsg = "";

if (isset($_POST['uploadPost'])) {

    // collect inputs
    if (!empty($_POST['title'])) {
        $title = $_POST['title'];
    }
    if (!empty($_POST['desc'])) {
        $desc = $_POST['desc'];
    }
    if (!empty($_POST['video'])) {
        $video = $_POST['video']; // now link instead of file
    }
    if (!empty($_POST['url'])) {
        $url = $_POST['url'];
    }
    if (!empty($_POST['amount'])) {
        $amount = $_POST['amount'];
    }
    if (!empty($_POST['b_amount'])) {
        $b_amount = $_POST['b_amount'];
    }

    // ✅ validations
    if (empty($_POST['title'])) {
        $titleErr = sendResponse("error", "Enter post title");
    } else if (empty($_POST['video'])) {
        $videoErr = sendResponse("error", "Enter video link (YouTube, Drive, etc.)");
    } else if (empty($_POST['url'])) {
        $urlErr = sendResponse("error", "Enter redirect URL");
    } else if (empty($_POST['desc'])) {
        $descErr = sendResponse("error", "Enter post description");
    } else {
        $title    = filter_string($_POST['title']);
        $desc     = filter_string($_POST['desc']);
        $amount   = filter_string($_POST['amount']);
        $b_amount = filter_string($_POST['b_amount']);
        $url      = filter_string($_POST['url']);
        $video    = filter_string($_POST['video']); // link only
        $time     = date("Y-m-d H:i:s");

        $sql = $link->prepare("INSERT INTO videos(title, video, description, url, amount, b_amount, time) VALUES(?,?,?,?,?,?,?)");
        $sql->bind_param("sssssss", $title, $video, $desc, $url, $amount, $b_amount, $time);

        if ($sql->execute()) {
            $postMsg = sendResponse("success", "Sponsored post added");
        } else {
            $postMsg = sendResponse("error", "Something went wrong");
        }
    }
}

if (isset($_POST['deletePost'])) {
    if (empty($_POST['id'])) {
        $spostMsg = sendResponse("error", "Something went wrong");
    } else {
        $id = filter_string($_POST['id']);

        $sql = $link->prepare("DELETE FROM videos WHERE id=?");
        $sql->bind_param("i", $id);

        if ($sql->execute()) {
            $spostMsg = sendResponse("success", "Sponsored post deleted");
        } else {
            $spostMsg = sendResponse("error", "Something went wrong");
        }
    }
}
?>