<?php 
// ✅ Show all PHP errors on page
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/admin/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/admin/actions/video.php";

include "inc/header.php";
?>

<div class="container-fluid">
    <div class="layout-specing">
        <div class="d-md-flex justify-content-between align-items-center">
            <h5 class="mb-0">Video Post</h5>
            <nav aria-label="breadcrumb" class="d-inline-block mt-2 mt-sm-0">
                <ul class="breadcrumb bg-transparent rounded mb-0 p-0">
                    <li class="breadcrumb-item text-capitalize"><a href="profile">Activity</a></li>
                    <li class="breadcrumb-item text-capitalize active" aria-current="page">Post</li>
                </ul>
            </nav>
        </div>

        <div class="row">
            <div class="col-lg-4 mt-4">
                <?php echo $videoMsg?>
                <div class="card border-0 rounded shadow">
                    <div class="card-body">
                        <h5 class="text-md-start text-center mb-0">Video Post:</h5>
                        <form method="POST">
                            <div class="row mt-4">
                                <?php echo $postMsg?>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Video Post Title</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="user" class="fea icon-sm icons"></i>
                                            <input id="title" type="text" class="form-control ps-5" placeholder="Post Title :" name="title" value="<?php echo $title?>">
                                        </div>
                                        <?php echo $titleErr?>
                                    </div>
                                </div><!--end col-->

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Video Link (YouTube, Drive etc.)</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="video" class="fea icon-sm icons"></i>
                                            <input id="video" type="text" class="form-control ps-5" placeholder="https://youtu.be/xxxx" name="video" value="<?php echo $video?>">
                                        </div>
                                        <?php echo $videoErr?>
                                    </div>
                                </div><!--end col-->

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Redirect URL (Social Media Link)</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="link" class="fea icon-sm icons"></i>
                                            <input id="url" type="text" class="form-control ps-5" placeholder="https://facebook.com/post" name="url" value="<?php echo $url?>">
                                        </div>
                                        <?php echo $urlErr?>
                                    </div>
                                </div><!--end col-->

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Amount Plan A</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="link" class="fea icon-sm icons"></i>
                                            <input id="amount" type="text" class="form-control ps-5" placeholder="e.g 500 " name="amount" value="<?php echo $amount?>">
                                        </div>
                                        <?php echo $amountErr?>
                                    </div>
                                </div><!--end col-->

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Amount Plan B</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="link" class="fea icon-sm icons"></i>
                                            <input id="b_amount" type="text" class="form-control ps-5" placeholder="e.g 300 " name="b_amount" value="<?php echo $b_amount?>">
                                        </div>
                                        <?php echo $b_amountErr?>
                                    </div>
                                </div><!--end col-->

                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">Description</label>
                                        <div class="form-icon position-relative">
                                            <i data-feather="mail" class="fea icon-sm icons"></i>
                                            <textarea id="default" style="width: 100%; height: 300px;" class="form-control ps-5" placeholder="Description :" name="desc"><?php echo $desc?></textarea>
                                        </div>
                                        <?php echo $descErr?>
                                    </div>
                                </div><!--end col-->

                                <div class="row">
                                    <div class="col-sm-12">
                                        <input type="submit" id="submit" name="uploadPost" class="btn btn-primary" value="Upload Post">
                                    </div><!--end col-->
                                </div><!--end row-->
                            </div>
                        </form><!--end form-->
                    </div>
                </div>
            </div>
        </div><!--end row-->

        <div class="col mt-4 pt-2" id="tables">
            <div class="component-wrapper rounded shadow">
                <div class="p-4 border-bottom">
                    <h4 class="title mb-0">Recent</h4>
                </div>

                <div class="p-4">
                    <div class="table-responsive bg-white shadow rounded">
                        <table class="table mb-0 table-center">
                            <thead>
                                <tr>
                                    <th scope="col" class="border-bottom">#</th>
                                    <th scope="col" class="border-bottom">Preview</th>
                                    <th scope="col" class="border-bottom">Title</th>
                                    <th scope="col" class="border-bottom">Redirect URL</th>
                                    <th scope="col" class="border-bottom">Date</th>
                                    <th scope="col" class="border-bottom">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $sql=$link->prepare("SELECT * FROM videos ORDER BY id DESC");
                                $sql->execute();
                                $result=$sql->get_result();
                                if($result->num_rows > 0){
                                    while($row=$result->fetch_assoc()){
                                        $id=$row['id'];
                                        $title=$row['title'];
                                        $date=$row['time'];
                                        $video=$row['video'];
                                        $url=$row['url'];
                                ?>
                                <tr>
                                    <th scope="row"><?php echo $id?></th>
                                    <td class="p-3">
                                        <?php if(!empty($video)){ ?>
                                            <iframe width="120" height="80" src="<?php echo $video ?>" frameborder="0" allowfullscreen></iframe>
                                        <?php } else { ?>
                                            No video
                                        <?php } ?>
                                    </td>
                                    <td><?php echo $title ?></td>
                                    <td><a href="<?php echo $url?>" target="_blank"><?php echo $url?></a></td>
                                    <td><?php echo $date?></td>
                                    <td>
                                        <button class="btn btn-danger deletePost">Delete</button>
                                        <input type="hidden" value="<?php echo $id?>" class="id">
                                    </td>
                                </tr>
                                <?php }} ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div><!--end col-->
    </div>
</div><!--end container-->

<script>
$(".deletePost").on("click", function(){
    let id = $(this).closest("tr").find(".id").val();
    deletePost(id);
});

function deletePost(id){
    let form = document.createElement('form');
    form.method = "POST";

    let actionInput = document.createElement('input');
    actionInput.type = "hidden";
    actionInput.name = "deletePost";
    actionInput.value = "deletePost";

    let idInput = document.createElement('input');
    idInput.type = "hidden";
    idInput.name = "id";
    idInput.value = id;

    form.appendChild(actionInput);
    form.appendChild(idInput);
    document.body.appendChild(form);
    form.submit();
}
</script>

<script src="/seotech/tinymce/tinymce.min.js"></script>
<script src="script.js"></script>

<script>
tinymce.init({
    selector: 'textarea#default',
    width: 300,
    height: 300,
    plugins:[
        'advlist', 'autolink', 'link', 'image', 'lists', 'charmap', 'preview', 'anchor', 'pagebreak',
        'searchreplace', 'wordcount', 'visualblocks', 'code', 'fullscreen', 'insertdatetime', 'media', 
        'table', 'emoticons', 'template', 'codesample'
    ],
    toolbar: 'undo redo | styles | bold italic underline | alignleft aligncenter alignright alignjustify |' + 
    'bullist numlist outdent indent | link image | print preview media fullscreen | ' +
    'forecolor backcolor emoticons',
    menu: {
        favs: {title: 'menu', items: 'code visualaid | searchreplace | emoticons'}
    },
    menubar: 'favs file edit view insert format tools table',
    content_style: 'body{font-family:Helvetica,Arial,sans-serif; font-size:16px}'
});
</script>

<?php include "inc/footer.php" ?>