<?php 
error_reporting(E_ALL);
ini_set('display_errors', '1');

require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/actions/formprocess.php";

// Database queries to count total, used, and unused coupons (Preserved for display/context if needed)
$sql = $link->prepare("SELECT * FROM coupons WHERE vendor=?");
$sql->bind_param("s", $username);
$sql->execute();
$result = $sql->get_result();
$totalCoupon = $result->num_rows;

$sql = $link->prepare("SELECT * FROM coupons WHERE vendor=? AND status='used'");
$sql->bind_param("s", $username);
$sql->execute();
$result = $sql->get_result();
$usedCoupon = $result->num_rows;

$sql = $link->prepare("SELECT * FROM coupons WHERE vendor=? AND status='active'");
$sql->bind_param("s", $username);
$sql->execute();
$result = $sql->get_result();
$unUsedCoupon = $result->num_rows;


// --- ORIGINAL PHP LOGIC for Coupon Checking ---
function checkCouponStatus($coupon, $link) {
    $countryname = "--";
    $type = "--"; // Initialize type to a default value

    $sql = $link->prepare("SELECT * FROM coupons WHERE coupon = ?");
    $sql->bind_param("s", $coupon);
    $sql->execute();
    $result = $sql->get_result();
    $numrow = $result->num_rows;

    if ($numrow > 0) {
        $row = $result->fetch_assoc();
        $status = $row['status'];
        $countryname = $row['countryname'];
        $type = $row['type']; // Get coupon type
        return array('status' => $status, 'countryname' => $countryname, 'type' => $type);
    }

    return array('status' => 'not_found', 'countryname' => $countryname, 'type' => $type);
}

$message = '';
$status_class = 'hidden';
$icon = '';

if (isset($_POST['status']) && isset($_POST["coupon"]) && !empty($_POST["coupon"])) {
    $input_coupon = trim($_POST["coupon"]);
    $status_info = checkCouponStatus($input_coupon, $link);
    $status = $status_info['status'];
    $countryname = $status_info['countryname'];
    $type = $status_info['type'];

    $sql = $link->prepare("SELECT * FROM users WHERE coupon = ?");
    $sql->bind_param("s", $input_coupon);
    $sql->execute();
    $result = $sql->get_result();
    $numrow = $result->num_rows;
    $usedBy = "a user";

    if ($numrow == 1) {
        $row = $result->fetch_assoc();
        $usedBy = htmlspecialchars($row['username']);
    }

    switch ($status) {
        case 'used':
            $message = "Coupon has already been used by {$usedBy}.";
            $status_class = 'bg-red-800 border-red-500';
            $icon = 'x-circle';
            break;
        case 'not_found':
            $message = "Coupon not found in the system.";
            $status_class = 'bg-gray-800 border-gray-500';
            $icon = 'search-x';
            break;
        case 'active':
            $message = "Coupon is ACTIVE. It is valid for {$countryname} with the {$type} plan.";
            $status_class = 'bg-emerald-800 border-emerald-500';
            $icon = 'check-circle';
            break;
        default:
             $message = "An unknown status was returned. Please check the code.";
             $status_class = 'bg-yellow-800 border-yellow-500';
             $icon = 'alert-triangle';
    }
}
// --- END ORIGINAL PHP LOGIC ---


$ptitle = "Verify Coupon Code";
include "inc/top.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($ptitle) ?></title>
    
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Load Lucide Icons for a clean, modern look -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <script>
        // Custom Tailwind Configuration to match the Ultimate Style colors
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        // ULTIMATE STYLE PALETTE
                        'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                        'card-surface': '#2F1252',   // Slightly Lighter Card Surface
                        'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                        'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                        'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                        'accent-gold': '#FBBF24',    // Gold Accent
                    }
                }
            }
        }
    </script>
    <style>
        body {
            background-color: #1f083d; /* bg-dark */
            color: #eef2ff; /* text-light */
            font-family: 'Inter', sans-serif;
            padding: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .main-content {
            flex-grow: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
        }
    </style>
</head>
<body>
    <div class="main-content">
        <div class="w-full max-w-md">

            <!-- Page Title -->
            <div class="text-center mb-10">
                <h3 class="text-3xl font-extrabold text-accent-primary flex items-center justify-center">
                    <i data-lucide="shield-check" class="w-7 h-7 mr-3"></i>
                    <?= htmlspecialchars($ptitle) ?>
                </h3>
            </div>
            
            <!-- Coupon Checker Box -->
            <div class="box bg-card-surface rounded-3xl p-8 shadow-2xl border border-accent-primary/50">
                <h2 class="text-2xl font-bold text-text-light mb-6">Enter Code to Verify</h2>
                
                <form method="post" class="space-y-6">
                    <div class="relative">
                        <input 
                            type="text" 
                            name="coupon" 
                            placeholder="Paste coupon code here" 
                            required 
                            class="w-full bg-bg-dark text-text-light placeholder-text-muted/70 p-4 rounded-xl border-2 border-accent-primary focus:border-accent-gold focus:ring-0 transition duration-200 text-center font-mono text-lg uppercase"
                            value="<?php echo isset($input_coupon) ? htmlspecialchars($input_coupon) : ''; ?>"
                        >
                        <i data-lucide="tag" class="w-5 h-5 absolute top-1/2 left-4 transform -translate-y-1/2 text-text-muted"></i>
                    </div>
                    
                    <button 
                        type="submit" 
                        name="status"
                        class="w-full py-4 bg-gradient-to-r from-accent-primary to-accent-primary/80 text-white font-extrabold rounded-xl shadow-lg hover:from-accent-gold hover:to-accent-gold/80 transition duration-300 transform hover:scale-[1.02] active:scale-95 flex items-center justify-center"
                    >
                        <i data-lucide="search" class="w-5 h-5 mr-2"></i>
                        CHECK STATUS
                    </button>
                </form>
                
                <?php if ($message): ?>
                    <!-- Status Message Box -->
                    <div class="msg mt-8 p-4 rounded-xl font-semibold text-text-light border-2 <?= $status_class ?> transition duration-500 ease-in-out">
                        <span class="flex items-start">
                            <i data-lucide="<?= $icon ?>" class="w-6 h-6 mr-3 mt-0.5"></i>
                            <span class="text-left"><?php echo $message; ?></span>
                        </span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="mt-auto">
        <?php include "inc/buttom.php" ?>
    </div>
    
    <script>
        // Initialize Lucide icons on load
        document.addEventListener('DOMContentLoaded', function() {
            lucide.createIcons();
        });
    </script>
</body>
</html>