<?php
$genMsg="";
$sql=$link->prepare("SELECT * FROM sponsoredpost WHERE SUBSTRING(date, 1, 10) = ? ");
$sql->bind_param("s", $date);
$sql->execute();
$result=$sql->get_result();
$numrow_task=$result->num_rows;
$row=$result->fetch_assoc();
$title=$image=$desc=$genMsg=$profileLink=$url=$desurl="";

if($numrow_task > 0){
    $title=$row['title'];    
    $amount=$sponsoredPostAmt;
    $desc=$row['description'];
    $image=$row['image'];
    $type=$row['type'];
    
    
    
    $sql=$link->prepare("SELECT * FROM profilelinks WHERE username=? AND type=?");
    $sql->bind_param("ss", $username, $type);
    $sql->execute();
    $result=$sql->get_result();
    $numrow_link=$result->num_rows;
    $row=$result->fetch_assoc();
    if($numrow_link > 0){
        $profileLink=$row['url'];
    }

}
else{
    $title="No daily task avaliable yet";
    $amount=0;
    $desc="There is no task avaliable at the moment, check back later";
}

$sql=$link->prepare("SELECT * FROM usersponsored WHERE SUBSTRING(date, 1, 10) = ? AND username=?");
$sql->bind_param("ss", $date, $username);
$sql->execute();
$result=$sql->get_result();
$numrow_userTask=$result->num_rows;
if($numrow_userTask > 0){
    $desc="You have performed the sponsored post task for today, wait till tomorrow for a new one";
}



if (isset($_POST['addTasks'])) {
    if ($numrow_userTask > 0) {
        $status = "error";
        $message = "You have performed this sponsored post task ";
        $genMsg = sendResponse($status, $message);
    } elseif ($numrow_task == 0) {
        $status = "error";
        $message = "Sponsored post not found";
        $genMsg = sendResponse($status, $message);
    } elseif (empty($_POST['desc'])) {
        $status = "error";
        $message = "Something went wrong 002";
        $genMsg = sendResponse($status, $message);
    } else {
        // Fetch the daily login bonus from the earning structure
        $sql = $link->prepare("SELECT spamt FROM earningstructure LIMIT 1");
        $sql->execute();
        $result = $sql->get_result();
        $row = $result->fetch_assoc();
        $spamt = $row['spamt'];
        
        $utf8_desc = utf8_encode($_POST['desc']);
        $shareUrl = "whatsapp://send?text=" . urlencode($utf8_desc);
        $sql = $link->prepare("INSERT INTO usersponsored (username, title, amount, date) VALUES (?, ?, ?, ?)");
        $sql->bind_param("ssss", $username, $title, $spamt, $dateTime);
        
        if ($sql->execute()) {
            $sql = $link->prepare("UPDATE users SET referralfunds = referralfunds + ? WHERE username = ?");
            $sql->bind_param("ss", $spamt, $username);
            $sql->execute();
            
            $type = "Advert Post";
            $sql = $link->prepare("INSERT INTO userearnings (username, type, amount, time, date) VALUES (?, ?, ?, ?, ?)");
            $sql->bind_param("sssss", $username, $type, $spamt, $time, $dateTime);
            $sql->execute();
            
            $status = "success";
            $message = "Sponsored post completed successfully (+ $spamt NP 👍)";
            $genMsg = sendResponse($status, $message);
            
            header("Location: $shareUrl");
            exit(); // Ensure no further code is executed after header redirection
        } else {
            $status = "error";
            $message = "Something went wrong";
            $genMsg = sendResponse($status, $message);
        }
    }
}


?>