<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";

if(isset($_POST["spin"])){

    if($spinWheel == "0"){
        $status="error"; 
        $message="Spin Wheel Point Accumulation currently unavailable";
        echo sendResponse($status, $message);
        exit;
    }

    if(empty($_POST['score'])){
        $status="error"; 
        $message="You didn't win, Goodluck next time.";
        echo sendResponse($status, $message);
        exit;
    }
    if(!is_numeric($_POST['score'])){
        $status="error"; 
        $message="Something went wrong 002";
        echo sendResponse($status, $message);
        exit;
    }

    $score = filter_string($_POST['score']);
    $type  = "spin_wheel";

    // ✅ Check if user has already spun today
    $today = date("Y-m-d");
    $check = $link->prepare("SELECT id FROM userearnings WHERE username=? AND type=? AND DATE(date)=?");
    $check->bind_param("sss", $username, $type, $today);
    $check->execute();
    $check->store_result();

    if($check->num_rows > 0){
        $status="error";
        $message="⏳ You already spun today. Try again tomorrow!";
        echo sendResponse($status, $message);
        exit;
    }
    $check->close();

    // ✅ Save earning
    $sql = $link->prepare("INSERT INTO userearnings(username, type, amount, time, date) VALUES(?,?,?,?,?)");
    $sql->bind_param("sssss", $username, $type, $score, $time, $dateTime);

    if($sql->execute()){
        // Update funds
        $sql = $link->prepare("UPDATE users SET funds=funds + ? WHERE username=?");
        $sql->bind_param("ss", $score, $username);
        $sql->execute();

        // Deduction rules
        if($score == "150"){ $deduct="50"; }
        else if ($score == "200"){ $deduct="80"; }
        else if ($score == "300"){ $deduct="100"; }
        else if ($score == "500"){ $deduct="200"; }
        else if ($score == "1000"){ $deduct="300"; }
        else if ($score == "1500"){ $deduct="500"; }
        else { $deduct = "0"; }

        if($deduct > 0){
            $sql = $link->prepare("UPDATE users SET funds=funds - ? WHERE username=?");
            $sql->bind_param("ss", $deduct, $username);
            $sql->execute();
        }

        $status="success";
        $message="🎉 You have successfully earned $score PT, added to your balance.";
        echo sendResponse($status, $message);
    } else {
        $status="error"; 
        $message="Something went wrong";
        echo sendResponse($status, $message);
    }
}
?>