<?php



// Fetch the task (adjust WHERE condition as needed)
$query = $link->prepare("SELECT * FROM usertasks WHERE id = ?");
$query->bind_param("i", $taskId); // Set your $taskId earlier in your code
$query->execute();
$result = $query->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $url = $row['url']; // ✅ Define $url from the row
} else {
    $url = ""; // fallback value if no row is found
}


$genMsg="";
if(isset($_POST['addTask'])){
    if(empty($_POST['reference'])){
        $status="error";
        $message="Something went wrong 001";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['url'])){
        $status="error";
        $message="Something went wrong 002";
        $genMsg=sendResponse($status, $message);
    }
    
    
    else{
        $reference=filter_string($_POST['reference']);
        /*$url=filter_string($_POST['url']);*/
        $sql=$link->prepare("SELECT * FROM  usertasks WHERE username=? AND reference=?");
        $sql->bind_param("ss", $username, $reference);
        $sql->execute();
        $result=$sql->get_result();
        $numrow_userTask=$result->num_rows;
        
        $sql=$link->prepare("SELECT * FROM dailytasks WHERE reference=?");
        $sql->bind_param("s", $reference);
        $sql->execute();
        $result=$sql->get_result();
        $numrow_task=$result->num_rows;
        $row=$result->fetch_assoc();
    
        if($numrow_userTask > 0){
            $status="error";
            $message="You have performed this task";
            $genMsg=sendResponse($status, $message);
        }
        else if($numrow_task == 0){
            $status="error";
            $message="Invalid task";
            $genMsg=sendResponse($status, $message);
        }
        else{
            $amount=$row['amount'];    
            $postTitle=$row['title'];    
            $postUrl=$row['url'];    
            
            $newStatus="completed";
            $sql=$link->prepare("INSERT INTO usertasks(username, title, url, amount, status, reference, date) VALUES(?,?,?,?,?,?,?)");
            $sql->bind_param("sssssss", $username, $postTitle, $postUrl, $amount, $newStatus, $reference, $dateTime);
            if($sql->execute()){
             $type="Click to earn";
             $sql=$link->prepare("INSERT INTO userearnings(username, type, amount, time, date) VALUES(?,?,?,?,?)");
               $sql->bind_param("sssss", $username, $type, $amount, $time, $dateTime);
                $sql->execute();
                
                $sql=$link->prepare("UPDATE users SET referralfunds=referralfunds + ? WHERE username=?");
                $sql->bind_param("ss", $amount, $username);
                $sql->execute();
            $message="Click to earn completed successfully (+ NP$amount 👍) ";
            $genMsg=sendResponse($status, $message);
                header("location:$url");
            }
            else{
                $status="error";
                $message="Something went wrong 003";
                $genMsg=sendResponse($status, $message);
            }
        }
    }
}

?>