<?php
$genMsg = $wallet = $amount = $isSelectedActivity = $isSelectedReferral = $isSelectedIndirectReferral = $isSelectedThirdIndirectReferral = $countryname = "";

// Fetch plantype
$sql = $link->prepare("SELECT plantype FROM users WHERE username=?");
$sql->bind_param("s", $username);
$sql->execute();
$result = $sql->get_result();
$row = $result->fetch_assoc();
$plantype = $row['plantype'];

// Fetch minrefwth and minactwth (assuming both are in earningstructure)
$sql2 = $link->prepare("SELECT minrefwth, minactwth FROM earningstructure WHERE type=?");
$sql2->bind_param("s", $plantype);
$sql2->execute();
$result2 = $sql2->get_result();
$row2 = $result2->fetch_assoc();

$minRefWithdrawAmt = $row2['minrefwth'];
$minActWithdrawAmt = $row2['minactwth'];
 
if (isset($_POST['withdraw'])) {

    $wallets = array("activity", "referral");
    $availableCountries = array("Cameroon", "Nigeria", "Ghana", "Sierra Leone", "South Africa", "Kenya", "Tanzania", "Uganda", "America");

/*
// Fetch user plantype
$sql = "SELECT plantype FROM users WHERE username = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();


// Fetch minrefwth using plantype
$sql2 = "SELECT minrefwth FROM earningstructure WHERE type = ?";
$stmt2 = $conn->prepare($sql2);
$stmt2->bind_param("s", $type);
$stmt2->execute();
$result2 = $stmt2->get_result();
$structure = $result2->fetch_assoc();
*/



    if (empty($_POST['amount'])) {
        $status = "error";
        $message = "Enter an amount to withdraw";
        $genMsg = sendResponse($status, $message);
    } else if (!is_numeric($_POST['amount'])) {
        $status = "error";
        $message = "Invalid amount";
        $genMsg = sendResponse($status, $message);
    /*} else if (empty($_POST['countryname'])) {
        $status = "error";
        $message = "Select your country";
        $genMsg = sendResponse($status, $message);
    } else if (!in_array($_POST['countryname'], $availableCountries)) {
        $status = "error";
        $message = "Invalid country";
        $genMsg = sendResponse($status, $message);*/
    } else if (empty($_POST['wallet'])) {
        $status = "error";
        $message = "Select wallet to withdraw from";
        $genMsg = sendResponse($status, $message);
    } else if (!in_array($_POST['wallet'], $wallets)) {
        $status = "error";
        $message = "Invalid wallet";
        $genMsg = sendResponse($status, $message);
    } else {
        $amount = filter_string($_POST['amount']);
        $countryname = filter_string($_POST['countryname']);
        $wallet = filter_string($_POST['wallet']);

        if ($wallet == "activity" && ($amount < $minActWithdrawAmt)) {
            $status = "error";
            $message = "Minimum activity wallet withdrawal is $minActWithdrawAmt TP";
            $genMsg = sendResponse($status, $message);
        } else if ($wallet == "referral" && ($amount < $minRefWithdrawAmt)) {
            $status = "error";
            $message = "Minimum wallet withdrawal is ₦$minRefWithdrawAmt ";
            $genMsg = sendResponse($status, $message);
        } else if (($wallet == "activity" && $amount > $funds) || ($wallet == "referral" && $amount > $referralFunds)) {
            $status = "error";
            $message = "Insufficient funds in your $wallet wallet";
            $genMsg = sendResponse($status, $message);
        } else if ($countryname == "America" && !$AmericaWithdraw) {
            $status = "error";
            $message = "$countryname withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($countryname == "Uganda" && !$UgandaWithdraw) {
            $status = "error";
            $message = "$countryname withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($countryname == "Tanzania" && !$TanzaniaWithdraw) {
            $status = "error";
            $message = "$countryname withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($countryname == "Kenya" && !$KenyaWithdraw) {
            $status = "error";
            $message = "$countryname withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($countryname == "South Africa" && !$SouthAfricaWithdraw) {
            $status = "error";
            $message = "$countryname withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($countryname == "Sierra Leone" && !$SierraLeoneWithdraw) {
            $status = "error";
            $message = "$countryname withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($countryname == "Ghana" && !$GhanaWithdraw) {
            $status = "error";
            $message = "$countryname withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($countryname == "Nigeria" && !$NigeriaWithdraw) {
            $status = "error";
            $message = "$countryname withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($countryname == "Cameroon" && !$CameroonWithdraw) {
            $status = "error";
            $message = "$countryname withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($wallet == "activity" && !$activityWithdraw) {
            $status = "error";
            $message = "Activity wallet withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else if ($wallet == "referral" && !$refWithdraw) {
            $status = "error";
            $message = "Referral withdrawal is currently not available";
            $genMsg = sendResponse($status, $message);
        } else {
            $sql = $link->prepare("SELECT * FROM withdrawals WHERE username=? AND status='pending'");
            $sql->bind_param("s", $username);
            $sql->execute();
            $result = $sql->get_result();
            $numrow_link = $result->num_rows;

            $sql = $link->prepare("SELECT * FROM bankaccounts WHERE username=?");
            $sql->bind_param("s", $username);
            $sql->execute();
            $result = $sql->get_result();
            $numrow_bnAcct = $result->num_rows;

            if ($numrow_bnAcct == 0) {
                $status = "error";
                $message = "You have not set up any bank account. Update your profile to withdraw";
                $genMsg = sendResponse($status, $message);
            } else if ($numrow_link > 0) {
                $status = "error";
                $message = "You have a pending withdrawal already";
                $genMsg = sendResponse($status, $message);
                
    
            } else {
                $sql = $link->prepare("INSERT INTO withdrawals(username, type, amount, description, countryname, number, plan, date) VALUES(?,?,?,?,?,?,?,?)");
                $sql->bind_param("ssssssss", $username, $wallet, $amount, $acctName, $countryname, $acctNum, $acctPlan, $dateTime);
                if ($sql->execute()) {
                    if ($wallet == "activity") {
                        $sql = $link->prepare("UPDATE users SET funds=funds - ? WHERE username=?");
                    } else {
                        $sql = $link->prepare("UPDATE users SET referralfunds=referralfunds - ? WHERE username=?");
                    }
                    $sql->bind_param("ss", $amount, $username);
                    $sql->execute();

                    $sql = $link->prepare("SELECT * FROM users WHERE username=?");
                    $sql->bind_param("s", $username);
                    $sql->execute();
                    $result = $sql->get_result();
                    $row = $result->fetch_assoc();
                    $funds = $row['funds'];
                    $referralfunds = $row['referralfunds'];

                    $status = "success";
                    $amount = number_format($amount, 2);
                    $message = "Successfully placed a soft withdrawal of ₦$amount from your video wallet. Kindly wait for the alert.";
                    $genMsg = sendResponse($status, $message);
                    
                } else {
                    $status = "error";
                    $message = "Something went wrong";
                    $genMsg = sendResponse($status, $message);
                }
            }
        }
    }
}
















if(isset($_POST['withdrawIndirect'])){
    if(empty($_POST['amount'])){
        $status="error";
        $message="Enter an amount to transfer";
        $genMsg=sendResponse($status, $message);
    }
    else if(!is_numeric($_POST['amount'])){
        $status="error";
        $message="Invalid amount";
        $genMsg=sendResponse($status, $message);
    }
    else if($_POST['amount'] > $indRefFunds){
        $status="error";
        $message="Insufficient indirect balance";
        $genMsg=sendResponse($status, $message);
    }
    
    
    else{
        //echo "$indRefFunds";
        //exit;
        $amount=filter_string($_POST['amount']);

        $sql=$link->prepare("UPDATE users SET indref=indref-?, referralfunds=referralfunds + ? WHERE username=?");
        $sql->bind_param("sss", $amount, $amount, $username);
        if($sql->execute()){
            $indRefFunds -= $amount;
            $referralFunds += $amount;
            
            $type="indirect_to-referral";
            $sql=$link->prepare("INSERT INTO userearnings(username, type, amount, time, date) VALUES(?,?,?,?,?)");
            $sql->bind_param("sssss", $username, $type, $amount, $time, $dateTime);
            $sql->execute();
                
            $status="success";
            $message="₦$amount Indirect earnings transferred to referral balance";
            $genMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong";
            $genMsg=sendResponse($status, $message);
        }
    }
}

?>