<?php
// --- ORIGINAL PHP INCLUDES ---
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/actions/account-settings.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/actions/password.php";

$ptitle="Payments Settings"; 
include "inc/top.php"
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($ptitle) ?></title>
    
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Load Lucide Icons for a clean, modern look -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <script>
        // Custom Tailwind Configuration to match the Ultimate Style colors
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        // ULTIMATE STYLE PALETTE
                        'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                        'card-surface': '#2F1252',   // Slightly Lighter Card Surface
                        'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                        'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                        'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                        'accent-gold': '#FBBF24',    // Gold Accent
                    }
                }
            }
        }
    </script>
    <style>
        /* Base styles */
        body {
            background-color: #1f083d; /* bg-dark */
            color: #eef2ff; /* text-light */
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
        }

        /* Input and Select styling for the dark theme */
        .ultimate-input, .ultimate-select {
            width: 100%;
            padding: 15px;
            margin-bottom: 18px;
            border: 2px solid #4F1C8B; /* Darker purple border */
            background-color: #1a0631; /* Even darker background for input */
            color: #eef2ff;
            border-radius: 12px;
            font-size: 15px;
            transition: border-color 0.3s, box-shadow 0.3s;
        }

        .ultimate-input:focus, .ultimate-select:focus {
            outline: none;
            border-color: #6d28d9; /* accent-primary */
            box-shadow: 0 0 0 2px rgba(109, 40, 217, 0.5);
        }

        /* Readonly fields should look distinct but fit the theme */
        .ultimate-input[readonly] {
            background: #2F1252; /* card-surface */
            color: #A78BFA; /* text-muted */
            border-color: #2F1252;
            cursor: default;
        }
        
        /* Select specific overrides */
        .ultimate-select {
            appearance: none; /* Hide default arrow */
            background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="%23A78BFA" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down"><path d="m6 9 6 6 6-6"/></svg>');
            background-repeat: no-repeat;
            background-position: right 15px center;
            padding-right: 40px;
        }
    </style>
</head>
<body>
  <div class="container max-w-lg mx-auto p-4 sm:p-6">
    
    <!-- Page Header -->
    <h2 class="text-3xl font-extrabold text-accent-primary mb-8 text-center flex items-center justify-center">
        <i data-lucide="cog" class="w-7 h-7 mr-3"></i>
        Payments Settings
    </h2>
    
    <!-- Bank Settings Card -->
    <div class="bg-card-surface p-6 rounded-2xl shadow-2xl border border-accent-primary/50">

        <!-- Current Bank Details Section -->
        <div class="mb-8">
            <h3 class="text-xl font-bold text-text-light mb-4 flex items-center border-b border-bg-dark/50 pb-2">
                <i data-lucide="wallet" class="w-5 h-5 mr-2 text-accent-gold"></i>
                Your Current Bank
            </h3>
            
            <label class="block text-text-muted font-medium mb-1">Bank Name</label>
            <input type="text" value="<?= $bankName ?>" placeholder="Never set yet" class="ultimate-input" readonly>

            <label class="block text-text-muted font-medium mb-1">Account Number</label>
            <input type="text" value="<?= $acctNum ?>" placeholder="Never set yet" class="ultimate-input" readonly>

            <label class="block text-text-muted font-medium mb-1">Account Holder Name</label>
            <input type="text" value="<?= $acctName ?>" placeholder="Never set yet" class="ultimate-input" readonly>
        </div>


        <!-- Edit Bank Form Section -->
        <form method="post" action="">
            <h3 class="text-xl font-bold text-text-light mb-4 flex items-center border-b border-accent-primary/50 pb-2">
                <i data-lucide="edit-3" class="w-5 h-5 mr-2 text-accent-primary"></i>
                Update Bank Details
            </h3>

            <label class="block text-text-muted font-medium mb-1">Select Bank</label>
            <div class="relative mb-6">
                <!-- NOTE: The class is changed to ultimate-select -->
                <select class="ultimate-select" name="bankName" id="bankName">
                    <!-- NOTE: Original PHP logic for selected option -->
                    <option disabled selected><?php echo $bankName?></option>
                    <?php
                        // --- ORIGINAL PHP LOGIC START ---
                        $sql=$link->prepare("SELECT * FROM banks");
                        $sql->execute();
                        $result=$sql->get_result();
                        $numrow=$result->num_rows;
                        if($numrow > 0){
                            while($row=$result->fetch_assoc()){
                                $bank=$row['bankname'];
                                $code=$row['bankcode'];
                                $codeBank=$code."_".$bank;
                                $selected="";
                                
                                if($bankCode == $code){
                                    $selected="selected";
                                }
                                echo "<option value='$codeBank' $selected>".htmlspecialchars($bank)."</option>";
                            }
                        }
                        // --- ORIGINAL PHP LOGIC END ---
                    ?>
                </select>
            </div>

            <label class="block text-text-muted font-medium mb-1">Account Number</label>
            <!-- NOTE: The class is changed to ultimate-input -->
            <input type="number" id="acctNum" name="acctNum" placeholder="Enter account number" class="ultimate-input" required>

            <label class="block text-text-muted font-medium mb-1">Account Holder Name</label>
            <!-- NOTE: The class is changed to ultimate-input -->
            <input type="text" id="acctName" name="acctName" placeholder="Enter account holder name" class="ultimate-input" required>

            <!-- Update Button (Ultimate Style) -->
            <button type="submit" name="saveBank" 
                    class="w-full py-3 bg-accent-primary text-text-light font-bold rounded-xl shadow-lg hover:bg-indigo-600 transition duration-300 transform hover:scale-[1.01] flex items-center justify-center">
                <i data-lucide="save" class="w-5 h-5 mr-2"></i> Update Bank
            </button>
        </form>
    </div>
  </div>

<script>
    // Initialize Lucide icons on load
    window.onload = function() {
        lucide.createIcons();
    };
    
</script>
<?php include "inc/nav.php" ?>