<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";

$ptitle = "Earning History";

// PHP LOGIC: Fetch earnings history for the current user
$sql = $link->prepare("SELECT type, amount, date FROM userearnings WHERE username = ? ORDER BY date DESC");
$sql->bind_param("s", $username); // Assuming $username holds the current user identifier
$sql->execute();
$result = $sql->get_result();
$num_earnings = $result->num_rows;

// Fetch total earnings for a summary card (optional, but good for professionalism)
$sql_total = $link->prepare("SELECT SUM(amount) AS total_earned FROM userearnings WHERE username = ?");
$sql_total->bind_param("s", $username);
$sql_total->execute();
$total_result = $sql_total->get_result();
$total_row = $total_result->fetch_assoc();
$total_earned = number_format($total_row['total_earned'] ?? 0, 2);

include "inc/top.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= htmlspecialchars($ptitle) ?></title>

<!-- Load Tailwind CSS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdn.jsdelivr.net/npm/clipboard@2/dist/clipboard.min.js"></script>
<script src="https://cdn.tailwindcss.com"></script>
<!-- Load Lucide Icons for a clean, modern look -->
<script src="https://unpkg.com/lucide@latest"></script>

<script>
    // Custom Tailwind Configuration to match the Ultimate Style colors
    tailwind.config = {
        theme: {
            extend: {
                fontFamily: {
                    sans: ['Inter', 'sans-serif'],
                },
                colors: {
                    // ULTIMATE STYLE PALETTE
                    'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                    'card-surface': '#2F1252',   // Slightly Lighter Card Surface
                    'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                    'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                    'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                    'accent-gold': '#FBBF24',    // Gold Accent
                    'earning-green': '#10b981',  // Emerald Green for income
                }
            }
        }
    }
</script>
<style>
    body {
        background-color: #1f083d; /* bg-dark */
        color: #eef2ff; /* text-light */
        font-family: 'Inter', sans-serif;
        padding: 0;
    }

    /* Card styling */
    .card-style {
        background-color: #2F1252; /* card-surface */
        border-radius: 16px;
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.4);
    }

    /* Table styling for dark mode */
    .table-custom th {
        background: #2F1252; /* card-surface */
        color: #A78BFA; /* text-muted */
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.8rem;
    }
    .table-custom td {
        background: #1a0631; /* Even darker row background */
        color: #eef2ff;
        border-bottom: 1px solid rgba(255, 255, 255, 0.05);
    }
    .table-custom tr:nth-child(even) td {
        background: #1f083d; /* bg-dark for alternating rows */
    }
    .table-custom td:first-child { border-top-left-radius: 8px; border-bottom-left-radius: 8px; }
    .table-custom td:last-child { border-top-right-radius: 8px; border-bottom-right-radius: 8px; }
</style>
</head>
<body>
<div class="p-4 sm:p-6 max-w-4xl mx-auto">

    <!-- Page Title -->
    <div class="text-center mb-6">
        <h3 class="text-3xl font-extrabold text-accent-primary flex items-center justify-center">
            <i data-lucide="line-chart" class="w-7 h-7 mr-3"></i>
            <?= htmlspecialchars($ptitle) ?>
        </h3>
    </div>

    <!-- Summary Card: Total Earned -->
    <div class="card-style shadow-xl p-6 mb-8 border-t-4 border-earning-green">
        <p class="text-sm font-medium text-text-muted uppercase tracking-wider mb-2">Total Earnings</p>
        <h1 class="text-5xl font-extrabold text-earning-green">₦<?php echo $total_earned; ?></h1>
    </div>

    <!-- Earnings History Table Card -->
    <div class="card-style overflow-hidden shadow-2xl p-0">
        <h4 class="text-xl font-bold text-text-light p-4 border-b border-bg-dark/50 flex items-center">
             <i data-lucide="history" class="w-5 h-5 mr-2 text-text-muted"></i>
            Transaction Log
        </h4>
        <div class="overflow-x-auto">
            <table class="table-custom min-w-full divide-y divide-bg-dark">
                <thead>
                    <tr>
                        <th class="px-6 py-3">Source / Type</th>
                        <th class="px-6 py-3 text-right">Amount Earned</th>
                        <th class="px-6 py-3">Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($num_earnings > 0): ?>
                        <?php while($row = $result->fetch_assoc()): ?>
                        <tr class="transition duration-150 ease-in-out hover:bg-card-surface/70">
                            <td class="px-6 py-4 whitespace-nowrap font-medium text-text-light capitalize">
                                <span class="flex items-center">
                                    <i data-lucide="trending-up" class="w-4 h-4 mr-2 text-earning-green"></i>
                                    <?php echo htmlspecialchars($row['type']); ?>
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right font-bold text-earning-green">
                                +₦<?php echo number_format($row['amount'], 2); ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-text-muted text-sm">
                                <?php echo date('M d, Y | h:i A', strtotime($row['date'])); ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="3" class="px-6 py-4 text-center text-text-muted">No earning transactions recorded yet.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    // Initialize Lucide icons on load
    document.addEventListener('DOMContentLoaded', function() {
        lucide.createIcons();
    });
</script>
<br><br><br><br>
<?php include "inc/nav.php" ?>
</body>
</html>