<!-- 5. Bottom Navigation (Fixed) -->
    <nav class="fixed bottom-0 w-full h-16 flex justify-around items-center bg-card-surface shadow-top-xl z-50 border-t border-accent-primary/50">
        <!-- Hardcoded from PHP loop -->
        <a href="task.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-text-muted transition duration-200">
            <i data-lucide="clipboard-list" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">Task</span>
        </a>
        <a href="quiz.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-text-muted transition duration-200">
            <i data-lucide="file-text" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">Quiz</span>
        </a>
        <a href="index.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-accent-primary transition duration-200 active">
            <i data-lucide="home" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">Home</span>
        </a>
        <a href="histroy.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-text-muted transition duration-200">
            <i data-lucide="history" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">History</span>
        </a>
        <a href="setting.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-text-muted transition duration-200">
            <i data-lucide="user" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">Me</span>
        </a>
    </nav>


    <!-- JavaScript for Interactivity -->
    <script>
        const leftSidebar = document.getElementById('left-sidebar');
        const rightSidebar = document.getElementById('right-sidebar');
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        const copyMessage = document.getElementById('copy-message');

        // --- Sidebar Toggles ---
        function toggleLeftSidebar() {
            const isOpen = !leftSidebar.classList.contains('-translate-x-full');
            
            if (isOpen) {
                // Close it
                leftSidebar.classList.add('-translate-x-full');
                sidebarOverlay.classList.remove('opacity-100', 'visible');
                sidebarOverlay.classList.add('opacity-0', 'invisible');
            } else {
                // Open it, and ensure right is closed
                leftSidebar.classList.remove('-translate-x-full');
                rightSidebar.classList.remove('scale-y-100', 'opacity-100');
                rightSidebar.classList.add('scale-y-0', 'opacity-0');
                sidebarOverlay.classList.remove('opacity-0', 'invisible');
                sidebarOverlay.classList.add('opacity-100', 'visible');
            }
        }

        function toggleRightSidebar() {
            const isOpen = !rightSidebar.classList.contains('scale-y-0');
            
            if (isOpen) {
                // Close it
                rightSidebar.classList.remove('scale-y-100', 'opacity-100');
                rightSidebar.classList.add('scale-y-0', 'opacity-0');
            } else {
                // Open it, and ensure left is closed
                rightSidebar.classList.remove('scale-y-0', 'opacity-0');
                rightSidebar.classList.add('scale-y-100', 'opacity-100');
                
                leftSidebar.classList.add('-translate-x-full');
                sidebarOverlay.classList.remove('opacity-100', 'visible');
                sidebarOverlay.classList.add('opacity-0', 'invisible');
            }
        }

        // --- Referral Copy Functionality ---
        function copyReferralLink() {
            const linkInput = document.getElementById('referral-link-input');
            
            // Select the text in the input field
            linkInput.select();
            linkInput.setSelectionRange(0, 99999); 

            // Use document.execCommand('copy') for better compatibility in iframe environments
            document.execCommand('copy');
            
            // Show success message
            copyMessage.classList.remove('invisible', 'opacity-0');
            copyMessage.classList.add('visible', 'opacity-100');
            
            // Hide message after 3 seconds
            setTimeout(() => {
                copyMessage.classList.remove('visible', 'opacity-100');
                copyMessage.classList.add('invisible', 'opacity-0');
            }, 3000);
        }

        // --- Reveal Animation Observer ---
        // This makes the main dashboard cards fade in as you scroll down
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('is-visible');
                    // Stop observing after the element is visible
                    observer.unobserve(entry.target); 
                }
            });
        }, { threshold: 0.1 });

        document.querySelectorAll('.reveal-item').forEach(item => {
            observer.observe(item);
        });
        
        // --- Lucide Icon Initialization (MUST BE LAST) ---
        // Converts all data-lucide tags into SVG icons
        window.onload = function() {
             lucide.createIcons();
        };
       
    </script>
</body>
</html>