<?php ?>
<!DOCTYPE html>
    <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ultimate Profit Pro Dashboard</title>
    
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Load Lucide Icons for a clean, modern look -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <script>
        // Custom Tailwind Configuration to match the Ultimate Style colors
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        // ULTIMATE STYLE PALETTE
                        'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                        'card-surface': '#2F1252',   // Slightly Lighter Card/Sidebar Surface
                        'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                        'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                        'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                        'accent-gold': '#FBBF24',    // Gold Accent
                    }
                }
            }
        }
    </script>
    <style>
        /* Custom styles from the Ultimate Style template */
        :root {
            --primary-dark: #1f083d; 
            --primary-accent: #6d28d9; 
            --text-light: #eef2ff; 
        }
        body {
            /* Using Tailwind classes defined in the script for colors */
            font-family: 'Inter', sans-serif;
            background-color: var(--primary-dark); 
            color: var(--text-light);
            overflow-x: hidden; /* Prevent content shifting */
        }

        /* Sidebar transition */
        .sidebar {
            transition: transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            /* Background color set via Tailwind class in HTML but linked here for clarity */
            box-shadow: 4px 0 20px rgba(0, 0, 0, 0.7);
            z-index: 60;
        }

        /* Reveal Animation State (for Intersection Observer) */
        .reveal-item {
            opacity: 0;
            transform: translateY(40px);
            transition: opacity 0.6s ease-out, transform 0.6s ease-out;
            transition-delay: var(--delay, 0s); 
        }

        .reveal-item.is-visible {
            opacity: 1;
            transform: translateY(0);
        }

        /* Custom scrollbar for better look */
        ::-webkit-scrollbar {
            width: 6px;
        }
        ::-webkit-scrollbar-thumb {
            background-color: var(--primary-accent);
            border-radius: 10px;
        }
        
        /* Highlight for active bottom nav item */
        .nav-item.active {
            color: var(--primary-accent); /* Use primary accent color */
        }
    </style>
</head>

<body id="dashboard-body" class="pt-16 pb-16">

    <!-- Sidebar Overlay (To close left sidebar on outside click) -->
    <div id="sidebar-overlay" class="fixed inset-0 bg-black/50 opacity-0 invisible transition-opacity duration-300 z-59" onclick="toggleLeftSidebar()"></div>

    <!-- 1. Left Sidebar (Main Navigation Drawer) -->
    <nav id="left-sidebar" class="sidebar fixed top-0 left-0 h-full w-64 transform -translate-x-full p-4 overflow-y-auto bg-card-surface">
        <div class="text-xl font-extrabold text-accent-primary mb-8 flex items-center justify-between">
            <span class="tracking-wider">ULTIMATE</span>
            <!-- Close Button (when open) -->
            <button onclick="toggleLeftSidebar()" class="text-text-light hover:text-text-muted transition duration-200 p-1 rounded-full">
                 <i data-lucide="x" class="w-7 h-7"></i>
            </button>
        </div>

        <ul class="space-y-1">
            <!-- Main Options -->
            <li class="rounded-xl cursor-pointer bg-accent-primary/20 text-accent-primary transition duration-150">
                <a href="index.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="home" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Home</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="task.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="clipboard-list" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Task</span>
                </a>
            </li>
            <!--<li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="#" class="flex items-center p-3 text-text-light">
                    <i data-lucide="monitor-play" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Video</span>
                </a>
            </li>-->
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="ref.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="users" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Team</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="sppost.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="megaphone" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Sponsored Post</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="quiz.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="help-circle" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Quiz</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="#" class="flex items-center p-3 text-text-light">
                    <i data-lucide="phone" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Airtime</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="#" class="flex items-center p-3 text-text-light">
                    <i data-lucide="database" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Data</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="#" class="flex items-center p-3 text-text-light">
                    <i data-lucide="book-open" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Courses</span>
                </a>
            </li>
            
            <!-- Conditional Vendor's Lodge (Hardcoded since $isVendor was true) -->
          <?php if($role=="vendor"): ?><li class="rounded-xl bg-accent-gold/20 hover:bg-accent-gold/30 cursor-pointer transition duration-150 mt-4">
                <a href="vendor.php" class="flex items-center p-3 text-accent-gold hover:text-accent-gold/80">
                    <i data-lucide="store" class="w-5 h-5 mr-3"></i>
                    <span class="font-bold">Vendors Lodge</span>
                </a>
            </li>
            <?php endif ?>
            <!-- Separator -->
            <li class="my-4"><hr class="border-t border-accent-primary/50"></li>

            <!-- Sub Options -->
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="setting.php" class="flex items-center p-3">
                    <i data-lucide="settings" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Settings</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="bank.php" class="flex items-center p-3">
                    <i data-lucide="credit-card" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Bank</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-red-500/20 text-red-400 transition duration-150">
                <a href="logout.php" class="flex items-center p-3">
                    <i data-lucide="log-out" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Logout</span>
                </a>
            </li>
        </ul>
    </nav>

    <!-- 2. Right Sidebar (Profile Menu) -->
    <div id="right-sidebar" class="fixed w-48 right-4 top-16 bg-card-surface rounded-xl p-3 transform scale-y-0 opacity-0 transition-all duration-300 origin-top shadow-2xl z-55">
        <ul class="space-y-1">
            <li class="p-2 rounded-lg hover:bg-bg-dark/50 cursor-pointer transition duration-150" onclick="toggleRightSidebar()">
                <a href="profile.php" class="flex items-center text-text-light">
                    <i data-lucide="user" class="w-5 h-5 mr-2"></i> Profile
                </a>
            </li>
            <li class="p-2 rounded-lg hover:bg-red-500/20 cursor-pointer transition duration-150 border-t border-accent-primary/50 mt-1 pt-2" onclick="toggleRightSidebar()">
                <a href="logout.php" class="flex items-center text-red-400">
                    <i data-lucide="log-out" class="w-5 h-5 mr-2"></i> Logout
                </a>
            </li>
        </ul>
    </div>

    <!-- 3. Top Bar (Fixed) -->
    <header class="top-bar fixed w-full top-0 p-4 flex justify-between items-center h-16 bg-card-surface shadow-xl z-50">
        <!-- Left: Toggle Button -->
        <button onclick="toggleLeftSidebar()" class="text-text-light hover:text-accent-primary transition duration-200 p-1 rounded-full">
             <i data-lucide="menu" class="w-7 h-7" id="toggle-icon-open"></i>
        </button>

        <!-- Center: Logo/Title (Visible on mobile) -->
        <div class="text-lg font-extrabold text-accent-primary tracking-wider md:hidden">ULTIMATE</div>

        <!-- Right: Profile Image & Bell/Notification -->
        <div class="flex items-center space-x-4">
            <!-- Notification Bell -->
            <button class="relative text-text-light hover:text-accent-gold transition duration-200">
                <i data-lucide="bell" class="w-6 h-6"></i>
                <span class="absolute top-0 right-0 block h-2 w-2 rounded-full ring-2 ring-card-surface bg-red-500"></span>
            </button>
            
            <!-- Profile Image (Clickable) -->
            <img src="https://placehold.co/40x40/6d28d9/eef2ff?text=U" 
                 alt="Profile" 
                 class="w-10 h-10 rounded-full object-cover cursor-pointer border-2 border-accent-primary shadow-lg hover:shadow-xl transition duration-200" 
                 onclick="toggleRightSidebar()">
        </div>
    </header>