<?php 
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";
$totalBalance = (int)$referralFunds  + (int)$funds  + (int)$sponsoredPostAmt + (int)$taskAmt;
$ptitle="Dashboard";

$genMsg="";
$completedTotal = 0;
$pendingTotal = 0;

$sql = $link->prepare("SELECT * FROM usertasks WHERE username = ?");
$sql->bind_param("s", $username);
$sql->execute();
$result = $sql->get_result();
$numrow = $result->num_rows;

if ($numrow > 0) {
    while ($row = $result->fetch_assoc()) {
        $amount = $row['amount'];
        $status = $row['status'];

        if ($status == "completed") {
            $completedTotal += $amount;
        } elseif ($status == "pending") {
            $pendingTotal += $amount;
        }
    }
}

$planName="Oval Pro";
$sql=$link->prepare("SELECT SUM(amount) AS totalWithdrawn FROM withdrawals WHERE status = 'success' OR status = 'successful'  AND username=? ");
$sql->bind_param('s', $username) ;
$sql->execute();
$result=$sql->get_result();
$totalWithdrawn=$result->fetch_assoc()['totalWithdrawn'];

$sql = $link->prepare("SELECT * FROM users WHERE username = ?");
$sql->bind_param('s', $username);
$sql->execute();
$result = $sql->get_result();
$usertotalrefearnings = ""; // Initialize the variable
if ($result->num_rows == 1) {
    $row = $result->fetch_assoc();
    $usertotalrefearnings = $row['totalrefearnings']; // Assign the value
} else {
    // Handle the case where no rows are found
    // You may want to set a default value or show an error message
}

$sql = $link->prepare("SELECT * FROM users WHERE username = ?");
$sql->bind_param('s', $username);
$sql->execute();
$result = $sql->get_result();
$userIndReferralFunds = ""; // Initialize the variable
if ($result->num_rows == 1) {
    $row = $result->fetch_assoc();
    $userIndReferralFunds = $row['indref']; // Assign the value
} else {
    // Handle the case where no rows are found
    // You may want to set a default value or show an error message
}



$stmt = $link->prepare("SELECT COUNT(*) FROM quiz_history WHERE user = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$stmt->bind_result($donequiz);
$stmt->fetch();
$stmt->close();

if (!$donequiz) {
    $donequiz = 0;
}





// assuming you already have $link (mysqli connection) and $username


$stmt = $link->prepare("SELECT plantype FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

// fallback if no row
$planType = $row['plantype'] ?? '';

$displayPlan = "unknown"; // ✅ default value

if ($planType === 'plan_a') {
    $displayPlan = "pro";
} elseif ($planType === 'plan_b') {
    $displayPlan = "smart";
}




include "actions/currency_rates.php"  ?> 


<div><?php echo $genMsg?></div>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ultimate ashboard</title>
    
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Load Lucide Icons for a clean, modern look -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <script>
        // Custom Tailwind Configuration to match the Ultimate Style colors
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        // ULTIMATE STYLE PALETTE
                        'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                        'card-surface': '#2F1252',   // Slightly Lighter Card/Sidebar Surface
                        'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                        'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                        'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                        'accent-gold': '#FBBF24',    // Gold Accent
                    }
                }
            }
        }
    </script>
    <style>
        /* Custom styles from the Ultimate Style template */
        :root {
            --primary-dark: #1f083d; 
            --primary-accent: #6d28d9; 
            --text-light: #eef2ff; 
        }
        body {
            /* Using Tailwind classes defined in the script for colors */
            font-family: 'Inter', sans-serif;
            background-color: var(--primary-dark); 
            color: var(--text-light);
            overflow-x: hidden; /* Prevent content shifting */
        }

        /* Sidebar transition */
        .sidebar {
            transition: transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            /* Background color set via Tailwind class in HTML but linked here for clarity */
            box-shadow: 4px 0 20px rgba(0, 0, 0, 0.7);
            z-index: 60;
        }

        /* Reveal Animation State (for Intersection Observer) */
        .reveal-item {
            opacity: 0;
            transform: translateY(40px);
            transition: opacity 0.6s ease-out, transform 0.6s ease-out;
            transition-delay: var(--delay, 0s); 
        }

        .reveal-item.is-visible {
            opacity: 1;
            transform: translateY(0);
        }

        /* Custom scrollbar for better look */
        ::-webkit-scrollbar {
            width: 6px;
        }
        ::-webkit-scrollbar-thumb {
            background-color: var(--primary-accent);
            border-radius: 10px;
        }
        
        /* Highlight for active bottom nav item */
        .nav-item.active {
            color: var(--primary-accent); /* Use primary accent color */
        }
    </style>
</head>

<body id="dashboard-body" class="pt-16 pb-16">

    <!-- Sidebar Overlay (To close left sidebar on outside click) -->
    <div id="sidebar-overlay" class="fixed inset-0 bg-black/50 opacity-0 invisible transition-opacity duration-300 z-59" onclick="toggleLeftSidebar()"></div>

    <!-- 1. Left Sidebar (Main Navigation Drawer) -->
    <nav id="left-sidebar" class="sidebar fixed top-0 left-0 h-full w-64 transform -translate-x-full p-4 overflow-y-auto bg-card-surface">
        <div class="text-xl font-extrabold text-accent-primary mb-8 flex items-center justify-between">
            <span class="tracking-wider">ULTIMATE</span>
            <!-- Close Button (when open) -->
            <button onclick="toggleLeftSidebar()" class="text-text-light hover:text-text-muted transition duration-200 p-1 rounded-full">
                 <i data-lucide="x" class="w-7 h-7"></i>
            </button>
        </div>

        <ul class="space-y-1">
            <!-- Main Options -->
            <li class="rounded-xl cursor-pointer bg-accent-primary/20 text-accent-primary transition duration-150">
                <a href="index.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="home" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Home</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="task.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="clipboard-list" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Task</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="video.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="monitor-play" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Video</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="team.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="users" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Team</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="sppost.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="megaphone" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Sponsored Post</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="quiz.php" class="flex items-center p-3 text-text-light">
                    <i data-lucide="help-circle" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Quiz</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="#" class="flex items-center p-3 text-text-light">
                    <i data-lucide="phone" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Airtime</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="#" class="flex items-center p-3 text-text-light">
                    <i data-lucide="database" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Data</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="#" class="flex items-center p-3 text-text-light">
                    <i data-lucide="book-open" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Courses</span>
                </a>
            </li>
            
            <!-- Conditional Vendor's Lodge (Hardcoded since $isVendor was true) -->
            <?php if($role=="vendor"): ?><li class="rounded-xl bg-accent-gold/20 hover:bg-accent-gold/30 cursor-pointer transition duration-150 mt-4">
                <a href="vendor.php" class="flex items-center p-3 text-accent-gold hover:text-accent-gold/80">
                    <i data-lucide="store" class="w-5 h-5 mr-3"></i>
                    <span class="font-bold">Vendors Lodge</span>
                </a>
            </li>
            <?php endif ?>
            <!-- Separator -->
            <li class="my-4"><hr class="border-t border-accent-primary/50"></li>

            <!-- Sub Options -->
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="setting.php" class="flex items-center p-3">
                    <i data-lucide="settings" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Settings</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-card-surface/50 transition duration-150">
                <a href="bank.php" class="flex items-center p-3">
                    <i data-lucide="credit-card" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Bank</span>
                </a>
            </li>
            <li class="rounded-xl cursor-pointer hover:bg-red-500/20 text-red-400 transition duration-150">
                <a href="logout.php" class="flex items-center p-3">
                    <i data-lucide="log-out" class="w-5 h-5 mr-3"></i>
                    <span class="font-medium">Logout</span>
                </a>
            </li>
        </ul>
    </nav>

    <!-- 2. Right Sidebar (Profile Menu) -->
    <div id="right-sidebar" class="fixed w-48 right-4 top-16 bg-card-surface rounded-xl p-3 transform scale-y-0 opacity-0 transition-all duration-300 origin-top shadow-2xl z-55">
        <ul class="space-y-1">
            <li class="p-2 rounded-lg hover:bg-bg-dark/50 cursor-pointer transition duration-150" onclick="toggleRightSidebar()">
                <a href="profile.php" class="flex items-center text-text-light">
                    <i data-lucide="user" class="w-5 h-5 mr-2"></i> Profile
                </a>
            </li>
            <li class="p-2 rounded-lg hover:bg-red-500/20 cursor-pointer transition duration-150 border-t border-accent-primary/50 mt-1 pt-2" onclick="toggleRightSidebar()">
                <a href="logout.php" class="flex items-center text-red-400">
                    <i data-lucide="log-out" class="w-5 h-5 mr-2"></i> Logout
                </a>
            </li>
        </ul>
    </div>

    <!-- 3. Top Bar (Fixed) -->
    <header class="top-bar fixed w-full top-0 p-4 flex justify-between items-center h-16 bg-card-surface shadow-xl z-50">
        <!-- Left: Toggle Button -->
        <button onclick="toggleLeftSidebar()" class="text-text-light hover:text-accent-primary transition duration-200 p-1 rounded-full">
             <i data-lucide="menu" class="w-7 h-7" id="toggle-icon-open"></i>
        </button>

        <!-- Center: Logo/Title (Visible on mobile) -->
        <div class="text-lg font-extrabold text-accent-primary tracking-wider md:hidden">ULTIMATE</div>

        <!-- Right: Profile Image & Bell/Notification -->
        <div class="flex items-center space-x-4">
            <!-- Notification Bell -->
            <button class="relative text-text-light hover:text-accent-gold transition duration-200">
                <i data-lucide="bell" class="w-6 h-6"></i>
                <span class="absolute top-0 right-0 block h-2 w-2 rounded-full ring-2 ring-card-surface bg-red-500"></span>
            </button>
            
            <!-- Profile Image (Clickable) -->
            <img src="https://placehold.co/40x40/6d28d9/eef2ff?text=U" 
                 alt="Profile" 
                 class="w-10 h-10 rounded-full object-cover cursor-pointer border-2 border-accent-primary shadow-lg hover:shadow-xl transition duration-200" 
                 onclick="toggleRightSidebar()">
        </div>
    </header>

    <!-- 4. Main Dashboard Content (with padding for fixed header and footer) -->
    <main class="px-4 max-w-2xl mx-auto">
        
        <!-- Greeting -->
        <div class="mb-8 reveal-item" style="--delay: 0s;">
            <h2 class="text-2xl font-semibold text-text-muted">Hello, <span class="text-accent-primary font-extrabold"><?php echo $username ?></span>!</h2>
            <p class="text-sm text-text-muted mt-1">Monetize your influence and grow your income.</p>
        </div>

        <!-- Total Balance Card & Withdraw -->
        <div class="bg-card-surface rounded-2xl p-6 shadow-2xl border border-accent-primary/50 mb-8 reveal-item" style="--delay: 0.1s;">
            <div class="flex justify-between items-start mb-4">
                <h3 class="text-text-light font-medium text-lg flex items-center">
                    <i data-lucide="wallet" class="w-5 h-5 mr-2 text-accent-gold"></i>
                    Total Profit Balance
                </h3>
            </div>
            
            <!-- Replaced PHP variable with mock data value -->
            <p class="text-5xl font-extrabold text-accent-gold mb-6 tracking-tight">
                ₦<?php echo number_format($convertedAmount, 2) ?>
            </p>
            
            <a href="withdraw.php"<button class="w-full py-3 bg-accent-primary text-text-light font-bold rounded-xl shadow-lg hover:bg-indigo-600 transition duration-300 transform hover:scale-[1.01]">
                <i data-lucide="dollar-sign" class="w-5 h-5 mr-2 inline-block"></i> Withdraw Funds
            </button> </a>
        </div>

        <!-- Sub-stat Cards (Activity Earnings & Downlines) -->
        <div class="grid grid-cols-2 gap-4 mb-8">
            <!-- Activity Earnings Card -->
            <div class="bg-card-surface rounded-xl p-4 shadow-lg border-l-4 border-accent-primary reveal-item" style="--delay: 0.2s;">
                <p class="text-text-muted text-sm font-medium">Total Withdrawn</p>
                <!-- Replaced PHP variable with mock data value -->
                <p class="text-2xl font-bold text-text-light mt-1">₦<?php echo number_format($converted09, 2) ?></p>
            </div>
            <!-- Downlines Card -->
            <div class="bg-card-surface rounded-xl p-4 shadow-lg border-l-4 border-accent-primary reveal-item" style="--delay: 0.3s;">
                <p class="text-text-muted text-sm font-medium">Total Downlines</p>
                <!-- Replaced PHP variable with mock data value -->
                <p class="text-2xl font-bold text-text-light mt-1 flex items-center">
                    <?php echo number_format((int) $totalReferrals) ?>
                    <i data-lucide="users" class="w-5 h-5 ml-2 text-text-muted"></i>
                </p>
            </div>
        </div>

        <!-- WhatsApp Group Box -->
        <div class="bg-card-surface rounded-2xl p-6 shadow-xl border border-green-500/50 mb-8 reveal-item" style="--delay: 0.4s;">
            <h4 class="text-xl font-bold mb-3 flex items-center text-green-400">
                <i data-lucide="message-square" class="w-5 h-5 mr-2"></i> Join Official Community
            </h4>
            <p class="text-text-muted mb-4 text-sm">
                Instruct people to join the official WhatsApp group to get latest news and direct support.
            </p>
            <!-- Replaced PHP variable with mock data link -->
            <a href="https://chat.whatsapp.com/Kb8LuJTvDaS1pONqcjWhmE?mode=hqrt1" target="_blank"
               class="w-full inline-flex justify-center items-center py-3 bg-green-600 text-bg-dark font-bold rounded-xl shadow-md hover:bg-green-500 transition duration-300">
                <i data-lucide="external-link" class="w-5 h-5 mr-2"></i> Join WhatsApp Group
            </a>
        </div>

        <!-- Referral Link Box -->
        <div class="bg-card-surface rounded-2xl p-6 shadow-xl border border-accent-primary/50 reveal-item" style="--delay: 0.5s;">
            <h4 class="text-xl font-bold mb-3 flex items-center text-accent-primary">
                <i data-lucide="share" class="w-5 h-5 mr-2"></i> Refer & Get Upto 70% Commission
            </h4>
            <p class="text-text-muted mb-4 text-sm">
                Get Upto 70% commission when you refer a user to join our innovation.
            </p>
            
            <div class="relative flex items-center">
                <!-- Input Field - Replaced PHP variable with mock data value -->
                <input type="text" id="referral-link-input" readonly
                       value="<?php echo $sitelink ?>signup.php?ref=<?php echo $username ?>"
                       class="w-full py-3 px-4 bg-bg-dark/50 text-text-light border border-accent-primary/50 rounded-l-lg text-sm truncate focus:border-accent-primary focus:ring-accent-primary" />
                
                <!-- Copy Button -->
                <button onclick="copyReferralLink()" id="copy-button"
                        class="py-3 px-4 bg-accent-primary text-text-light font-bold rounded-r-lg shadow-md hover:bg-indigo-600 transition duration-200 flex-shrink-0 relative overflow-hidden">
                    <i data-lucide="clipboard" class="w-5 h-5"></i>
                </button>
            </div>
            
            <!-- Copy Success Message -->
            <div id="copy-message" class="text-sm text-accent-gold mt-2 font-semibold invisible opacity-0 transition duration-300">
                Referral link copied successfully!
            </div>
        </div>

    </main>
    
    <!-- 5. Bottom Navigation (Fixed) -->
    <nav class="fixed bottom-0 w-full h-16 flex justify-around items-center bg-card-surface shadow-top-xl z-50 border-t border-accent-primary/50">
        <!-- Hardcoded from PHP loop -->
        <a href="task.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-text-muted transition duration-200">
            <i data-lucide="clipboard-list" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">Task</span>
        </a>
        <a href="quiz.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-text-muted transition duration-200">
            <i data-lucide="file-text" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">Quiz</span>
        </a>
        <a href="index.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-accent-primary transition duration-200 active">
            <i data-lucide="home" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">Home</span>
        </a>
        <a href="history.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-text-muted transition duration-200">
            <i data-lucide="history" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">History</span>
        </a>
        <a href="setting.php" class="nav-item flex flex-col items-center justify-center text-xs p-1 text-text-muted transition duration-200">
            <i data-lucide="user" class="w-6 h-6 mb-0.5"></i>
            <span class="font-medium">Me</span>
        </a>
    </nav>


    <!-- JavaScript for Interactivity -->
    <script>
        const leftSidebar = document.getElementById('left-sidebar');
        const rightSidebar = document.getElementById('right-sidebar');
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        const copyMessage = document.getElementById('copy-message');

        // --- Sidebar Toggles ---
        function toggleLeftSidebar() {
            const isOpen = !leftSidebar.classList.contains('-translate-x-full');
            
            if (isOpen) {
                // Close it
                leftSidebar.classList.add('-translate-x-full');
                sidebarOverlay.classList.remove('opacity-100', 'visible');
                sidebarOverlay.classList.add('opacity-0', 'invisible');
            } else {
                // Open it, and ensure right is closed
                leftSidebar.classList.remove('-translate-x-full');
                rightSidebar.classList.remove('scale-y-100', 'opacity-100');
                rightSidebar.classList.add('scale-y-0', 'opacity-0');
                sidebarOverlay.classList.remove('opacity-0', 'invisible');
                sidebarOverlay.classList.add('opacity-100', 'visible');
            }
        }

        function toggleRightSidebar() {
            const isOpen = !rightSidebar.classList.contains('scale-y-0');
            
            if (isOpen) {
                // Close it
                rightSidebar.classList.remove('scale-y-100', 'opacity-100');
                rightSidebar.classList.add('scale-y-0', 'opacity-0');
            } else {
                // Open it, and ensure left is closed
                rightSidebar.classList.remove('scale-y-0', 'opacity-0');
                rightSidebar.classList.add('scale-y-100', 'opacity-100');
                
                leftSidebar.classList.add('-translate-x-full');
                sidebarOverlay.classList.remove('opacity-100', 'visible');
                sidebarOverlay.classList.add('opacity-0', 'invisible');
            }
        }

        // --- Referral Copy Functionality ---
        function copyReferralLink() {
            const linkInput = document.getElementById('referral-link-input');
            
            // Select the text in the input field
            linkInput.select();
            linkInput.setSelectionRange(0, 99999); 

            // Use document.execCommand('copy') for better compatibility in iframe environments
            document.execCommand('copy');
            
            // Show success message
            copyMessage.classList.remove('invisible', 'opacity-0');
            copyMessage.classList.add('visible', 'opacity-100');
            
            // Hide message after 3 seconds
            setTimeout(() => {
                copyMessage.classList.remove('visible', 'opacity-100');
                copyMessage.classList.add('invisible', 'opacity-0');
            }, 3000);
        }

        // --- Reveal Animation Observer ---
        // This makes the main dashboard cards fade in as you scroll down
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('is-visible');
                    // Stop observing after the element is visible
                    observer.unobserve(entry.target); 
                }
            });
        }, { threshold: 0.1 });

        document.querySelectorAll('.reveal-item').forEach(item => {
            observer.observe(item);
        });
        
        // --- Lucide Icon Initialization (MUST BE LAST) ---
        // Converts all data-lucide tags into SVG icons
        window.onload = function() {
             lucide.createIcons();
        };
       
    </script>
</body>
</html>