<?php
// --- ORIGINAL PHP INCLUDES ---
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";

if (!isset($_SESSION['username'])) die("Please login first.");
$username = $_SESSION['username'];
$type = $type['quiz'];

// Get user plantype
// NOTE: $link is assumed to be defined by the included files
$sql = $link->prepare("SELECT plantype FROM users WHERE username=?");
$sql->bind_param("s", $username);
$sql->execute();
$user = $sql->get_result()->fetch_assoc();
if (!$user) die("User not found.");
$planType = $user['plantype'];

// Handle quiz submission
if (isset($_POST['upload'])) {
    $quiz_id = intval($_POST['quiz_id']);
    $user_answer = intval($_POST['answer']);

    $sql = $link->prepare("SELECT * FROM quiz WHERE id=?");
    $sql->bind_param("i", $quiz_id);
    $sql->execute();
    $quiz = $sql->get_result()->fetch_assoc();

    if ($quiz) {
        $correct = ($user_answer === intval($quiz['correct_answer']));
        $earned = 0;
        $status = "wrong";

        if ($correct) {
            $earned = ($planType === "plan_a") ? $quiz['amount_a'] : $quiz['amount_b'];
            $status = "correct";

            $sql = $link->prepare("UPDATE users SET referralfunds = referralfunds + ? WHERE username=?");
            $sql->bind_param("ds", $earned, $username);
            $sql->execute();
        }
    

        $sql = $link->prepare("INSERT INTO quiz_history (user, quiz_id, status, earned) VALUES (?,?,?,?)");
        $sql->bind_param("sisd", $username, $quiz_id, $status, $earned);
        $sql->execute();
        if($sql->execute()){
             $type="Quiz Earning";
             $sql=$link->prepare("INSERT INTO userearnings(username, type, amount, time, date) VALUES(?,?,?,?,?)");
               $sql->bind_param("sssss", $username, $type, $earned, $time, $dateTime);
                $sql->execute();
        

        // Redirect to avoid form resubmission
        header("Location: ".$_SERVER['PHP_SELF']."?msg=" . urlencode(($correct ? "✅ Correct! You earned ₦$earned" : "❌ Wrong Answer!")));
        exit;
    }
}
}

// Fetch all unanswered quizzes
$sql = $link->prepare("
    SELECT * FROM quiz 
    WHERE id NOT IN (SELECT quiz_id FROM quiz_history WHERE user=?) 
    ORDER BY id ASC
");
$sql->bind_param("s", $username);
$sql->execute();
$quizzes = $sql->get_result();
$message = $_GET['msg'] ?? '';
include "inc/top.php"
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daily Quiz</title>
    
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Load Lucide Icons for a clean, modern look -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <script>
        // Custom Tailwind Configuration to match the Ultimate Style colors
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        // ULTIMATE STYLE PALETTE
                        'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                        'card-surface': '#2F1252',   // Slightly Lighter Card Surface
                        'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                        'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                        'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                        'accent-gold': '#FBBF24',    // Gold Accent (for rewards)
                        'status-correct': '#10b981', // Emerald 500
                        'status-wrong': '#ef4444',   // Red 500
                    }
                }
            }
        }
    </script>
    <style>
        /* Base styles */
        body {
            background-color: #1f083d; /* bg-dark */
            color: #eef2ff; /* text-light */
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
        }
        
        /* Custom radio button styling (Hides default radio, styles the label) */
        .option input[type="radio"] {
            position: absolute;
            opacity: 0;
            width: 0;
            height: 0;
        }

        .option label {
            display: block;
            background: #1a0631; /* Even darker background */
            color: #eef2ff;
            padding: 12px;
            border-radius: 8px;
            border: 2px solid #4F1C8B; /* Darker border */
            cursor: pointer;
            transition: all 0.2s;
            font-weight: 500;
            margin-bottom: 8px;
            display: flex;
            align-items: center;
        }

        /* Hover effect */
        .option label:hover {
            background: #250b40;
            border-color: #6d28d9; /* accent-primary */
        }

        /* Checked state */
        .option input[type="radio"]:checked + label {
            background: #4F1C8B; /* Darker purple when selected */
            border-color: #FBBF24; /* accent-gold border */
            box-shadow: 0 0 10px rgba(251, 191, 36, 0.4);
        }

        /* Custom checkmark indicator */
        .option label::before {
            content: '';
            width: 16px;
            height: 16px;
            border-radius: 50%;
            border: 2px solid #A78BFA;
            margin-right: 12px;
            display: inline-block;
            transition: all 0.2s;
            flex-shrink: 0;
        }

        .option input[type="radio"]:checked + label::before {
            background-color: #FBBF24; /* Fill with gold when checked */
            border-color: #FBBF24;
            box-shadow: 0 0 5px #FBBF24;
        }

    </style>
</head>
<body>

<div class="container p-4 sm:p-6 max-w-lg mx-auto">

    <!-- Header -->
    <h2 class="text-3xl font-extrabold text-accent-primary mb-8 text-center flex items-center justify-center">
        <i data-lucide="help-circle" class="w-7 h-7 mr-3"></i>
        Daily Quiz Challenge
    </h2>

    <!-- Message Area -->
    <?php if ($message): 
        $is_correct = str_contains($message, '✅ Correct');
        $msg_icon = $is_correct ? 'check-circle' : 'x-octagon';
        $msg_color = $is_correct ? 'status-correct' : 'status-wrong';
    ?>
        <div class="px-4 py-3 mb-6 rounded-xl border font-semibold flex items-center 
                    bg-<?php echo $msg_color; ?>/20 border-<?php echo $msg_color; ?> text-<?php echo $msg_color; ?>">
            <i data-lucide="<?php echo $msg_icon; ?>" class="w-5 h-5 mr-3"></i>
            <?php echo htmlspecialchars($message); ?>
        </div>
    <?php endif; ?>

    <!-- Quizzes List -->
    <?php if ($quizzes->num_rows > 0): ?>
        <?php while ($quiz = $quizzes->fetch_assoc()): 
            // Determine reward based on plan type
            $reward_amount = ($planType === "plan_a") ? $quiz['amount_a'] : $quiz['amount_b'];
        ?>
            <div class="quiz-box bg-card-surface p-5 rounded-xl shadow-2xl border border-accent-primary/50 mb-6">
                <form method="post">
                    <!-- Question -->
                    <p class="text-lg font-bold text-text-light mb-4 flex items-center">
                        <i data-lucide="target" class="w-5 h-5 mr-3 text-accent-gold"></i>
                        <?php echo htmlspecialchars($quiz['question']); ?>
                    </p>
                    
                    <!-- Reward Display -->
                    <div class="text-sm font-medium text-text-muted mb-4 border-b border-bg-dark/50 pb-2">
                        Reward for correct answer: 
                        <span class="text-accent-gold font-bold text-base">
                             ₦<?php echo number_format($reward_amount, 2); ?> (Plan: <?php echo htmlspecialchars($planType); ?>)
                        </span>
                    </div>

                    <!-- Options -->
                    <div class="space-y-2">
                        <div class="option">
                            <input type="radio" name="answer" value="1" id="quiz-<?php echo $quiz['id']; ?>-1" required> 
                            <label for="quiz-<?php echo $quiz['id']; ?>-1">
                                <?php echo htmlspecialchars($quiz['answer1']); ?>
                            </label>
                        </div>

                        <div class="option">
                            <input type="radio" name="answer" value="2" id="quiz-<?php echo $quiz['id']; ?>-2"> 
                            <label for="quiz-<?php echo $quiz['id']; ?>-2">
                                <?php echo htmlspecialchars($quiz['answer2']); ?>
                            </label>
                        </div>
                        
                        <div class="option">
                            <input type="radio" name="answer" value="3" id="quiz-<?php echo $quiz['id']; ?>-3"> 
                            <label for="quiz-<?php echo $quiz['id']; ?>-3">
                                <?php echo htmlspecialchars($quiz['answer3']); ?>
                            </label>
                        </div>
                    </div>

                    <input type="hidden" name="quiz_id" value="<?php echo $quiz['id']; ?>">
                    <button type="submit" name="upload" 
                            class="w-full py-3 mt-4 bg-accent-primary text-text-light font-bold rounded-xl shadow-lg hover:bg-indigo-600 transition duration-300 flex items-center justify-center">
                        <i data-lucide="send" class="w-5 h-5 mr-2"></i> Submit Answer
                    </button>
                </form>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <!-- All Quizzes Answered -->
        <div class="quiz-box bg-card-surface p-6 rounded-xl shadow-2xl border border-accent-gold/50 text-center mt-10">
            <i data-lucide="party-popper" class="w-10 h-10 text-accent-gold mb-3 mx-auto"></i>
            <p class="text-text-light font-medium text-lg">
                🎉 Congratulations!
            </p>
            <p class="text-text-muted text-base mt-1">
                You have answered all available quizzes. Check back later for new challenges!
            </p>
        </div>
    <?php endif; ?>
</div>

<script>
    // Initialize Lucide icons on load
    window.onload = function() {
        lucide.createIcons();
    };
</script>

</body>
</html>
<?php include "inc/nav.php" // Assuming this handles bottom navigation/footer structure ?>