<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";

// Prepare and execute query
$sql = $link->prepare("SELECT username, date FROM referrals WHERE referral = ?");
$sql->bind_param("s", $username);
$sql->execute();
$result = $sql->get_result();

// Count total referrals
$total_referrals = $result->num_rows;

// Assuming $sitelink is defined in one of the included files
$referral_link = (isset($sitelink) ? $sitelink : 'https://example.com/')."register.php?ref=".$username;

include "inc/top.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Referral Dashboard</title>

<!-- Load Tailwind CSS -->
<script src="https://cdn.tailwindcss.com"></script>
<!-- Load Lucide Icons for a clean, modern look -->
<script src="https://unpkg.com/lucide@latest"></script>

<script>
    // Custom Tailwind Configuration to match the Ultimate Style colors
    tailwind.config = {
        theme: {
            extend: {
                fontFamily: {
                    sans: ['Inter', 'sans-serif'],
                },
                colors: {
                    // ULTIMATE STYLE PALETTE
                    'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                    'card-surface': '#2F1252',   // Slightly Lighter Card Surface
                    'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                    'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                    'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                    'accent-gold': '#FBBF24',    // Gold Accent
                }
            }
        }
    }
</script>
<style>
    body {
        background-color: #1f083d; /* bg-dark */
        color: #eef2ff; /* text-light */
        font-family: 'Inter', sans-serif;
        padding: 0;
    }

    /* Table styling for dark mode */
    .table-custom th {
        background: #2F1252; /* card-surface */
        color: #A78BFA; /* text-muted */
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.8rem;
    }
    .table-custom td {
        background: #1a0631; /* Even darker row background */
        color: #eef2ff;
    }
    .table-custom tr:nth-child(even) td {
        background: #1f083d; /* bg-dark for alternating rows */
    }
</style>
</head>
<body>
<div class="p-4 sm:p-6 max-w-4xl mx-auto">
    
    <div class="text-center mb-6">
        <h3 class="text-3xl font-extrabold text-accent-primary flex items-center justify-center">
            <i data-lucide="users" class="w-7 h-7 mr-3"></i>
            Referral Dashboard
        </h3>
    </div>

    <!-- Total Referrals Card -->
    <div class="card-style bg-card-surface p-6 rounded-2xl shadow-xl mb-6 border-t-4 border-accent-gold">
        <p class="text-sm font-medium text-text-muted uppercase tracking-wider mb-2">TOTAL TEAM</p>
        <h1 class="text-5xl font-extrabold text-accent-gold"><?php echo $total_referrals; ?></h1>
    </div>

    <!-- Referral Link Box -->
    <div class="referral-box bg-accent-primary p-4 rounded-xl shadow-lg flex justify-between items-center mb-8 border border-accent-gold/50">
        <span id="refLink" class="text-text-light text-sm md:text-base break-all pr-3">
            <?php echo htmlspecialchars($referral_link) ?>
        </span>
        <button class="flex-shrink-0 bg-accent-gold text-bg-dark p-3 rounded-lg hover:bg-yellow-400 transition" onclick="copyReferral()">
            <i data-lucide="clipboard" class="w-5 h-5"></i>
        </button>
    </div>

    <!-- Referral Table -->
    <div class="bg-card-surface rounded-xl shadow-2xl overflow-hidden p-0">
        <h4 class="text-xl font-bold text-text-light p-4 border-b border-bg-dark/50 flex items-center">
             <i data-lucide="list-ordered" class="w-5 h-5 mr-2 text-text-muted"></i>
            Referred Users
        </h4>
        <div class="overflow-x-auto">
            <table class="table-custom min-w-full divide-y divide-bg-dark">
                <thead>
                    <tr>
                        <th class="px-6 py-3">Username</th>
                        <th class="px-6 py-3">Register Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($total_referrals > 0): ?>
                        <?php 
                        // Reset result pointer to start of data
                        $result->data_seek(0);
                        while($row = $result->fetch_assoc()): 
                        ?>
                        <tr class="transition duration-150 ease-in-out hover:bg-card-surface/70">
                            <td class="px-6 py-4 whitespace-nowrap font-medium text-text-light"><?php echo htmlspecialchars($row['username']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-text-muted"><?php echo date('M d, Y', strtotime($row['date'])); ?></td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="2" class="px-6 py-4 text-center text-text-muted">No referrals yet. Share your link to start earning!</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Custom Tailwind Toast Notification -->
<div class="fixed bottom-5 left-1/2 -translate-x-1/2 bg-accent-primary text-text-light py-3 px-5 rounded-xl shadow-lg z-50 transition duration-300 ease-in-out" id="ultimate-toast" style="display: none;">
    <span class="flex items-center">
        <i data-lucide="check-circle" class="w-5 h-5 mr-2"></i>
        Referral link copied!
    </span>
</div>

<script>
    // Initialize Lucide icons
    document.addEventListener('DOMContentLoaded', function() {
        lucide.createIcons();
    });

    function copyReferral() {
        var refLink = document.getElementById("refLink").textContent.trim();
        var toast = document.getElementById("ultimate-toast");
        
        // Use document.execCommand('copy') as a fallback/compatibility option
        if (!navigator.clipboard) {
            // Fallback for environments where clipboard API is restricted
            var tempInput = document.createElement('textarea');
            tempInput.value = refLink;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);
            
            showToast();

        } else {
            // Standard Clipboard API
            navigator.clipboard.writeText(refLink).then(() => {
                showToast();
            }).catch(err => {
                console.error('Failed to copy: ', err);
                // Simple console log for errors, as we avoid native alerts
            });
        }
    }
    
    function showToast() {
        let toast = document.getElementById("ultimate-toast");
        toast.style.display = "block";
        setTimeout(() => {
            toast.style.display = "none";
        }, 2000);
    }
</script>
<br><br><br><br>
<?php include "inc/nav.php" ?>