<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/actions/account-settings.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/actions/password.php";

// Fetch country name
$sql = $link->prepare("SELECT * FROM users WHERE username = ?");
$sql->bind_param('s', $username);
$sql->execute();
$result = $sql->get_result();
$countryname = "";
if ($result->num_rows == 1) {
    $row = $result->fetch_assoc();
    // Assuming these variables are defined in the included files or global scope, 
    // the original code only extracts countryname here.
    $countryname = $row['countryname']; 
}

$ptitle = "Account Settings";
include "inc/top.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= htmlspecialchars($ptitle) ?></title>
  
  <!-- Load Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Load Lucide Icons for a clean, modern look -->
  <script src="https://unpkg.com/lucide@latest"></script>
  
  <script>
      // Custom Tailwind Configuration to match the Ultimate Style colors
      tailwind.config = {
          theme: {
              extend: {
                  fontFamily: {
                      sans: ['Inter', 'sans-serif'],
                  },
                  colors: {
                      // ULTIMATE STYLE PALETTE
                      'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                      'card-surface': '#2F1252',   // Slightly Lighter Card Surface
                      'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                      'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                      'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                      'accent-gold': '#FBBF24',    // Gold Accent
                  }
              }
          }
      }
  </script>
  <style>
    /* Base styles */
    body {
      background-color: #1f083d; /* bg-dark */
      color: #eef2ff; /* text-light */
      font-family: 'Inter', sans-serif;
      margin: 0;
      padding: 0;
    }
    
    /* Input field styling for the dark theme */
    .ultimate-input {
      padding: 14px 12px;
      border: 2px solid #4F1C8B; /* Darker purple border */
      background-color: #1a0631; /* Even darker background for input */
      color: #eef2ff;
      border-radius: 10px;
      font-size: 15px;
      width: 100%;
      transition: border-color 0.3s, box-shadow 0.3s;
    }

    .ultimate-input:focus {
      outline: none;
      border-color: #6d28d9; /* accent-primary */
      box-shadow: 0 0 0 2px rgba(109, 40, 217, 0.5);
    }

    /* Readonly fields should look distinct but fit the theme */
    .ultimate-input[readonly] {
      background: #2F1252; /* card-surface */
      color: #A78BFA; /* text-muted */
      border-color: #2F1252;
      cursor: default;
    }
  </style>
</head>

<body>
<div class="page-content footer-clear p-4 sm:p-6 max-w-lg mx-auto">
  
  <h2 class="text-3xl font-extrabold text-accent-primary mb-8 text-center flex items-center justify-center">
    <i data-lucide="user-cog" class="w-7 h-7 mr-3"></i>
    <?= htmlspecialchars($ptitle) ?>
  </h2>

  <div class="card-style bg-card-surface p-6 rounded-2xl shadow-2xl border border-accent-primary/50 text-center">
    
    <!-- Profile Image Display (Original Logic) -->
    <?php
    $image_path = 'assets/img/profilephotos/' . $profileImg;
    if ($profileImg == "no-avatar.png" || empty($profileImg)) {
        // Fallback to a placeholder if $profileImg is unset or the default
        $image_source = "../images/avatar.png"; 
    } else {
        // Use the actual path if available
        $image_source = "assets/img/profilephotos/" . $profileImg;
    }
    ?>
    <img src="<?= htmlspecialchars($image_source) ?>" alt="profile" 
         class="profile-img w-28 h-28 rounded-full object-cover border-4 border-accent-gold mx-auto mb-4 bg-gray-500">
    

    <form method="post" enctype="multipart/form-data" action="">
      
      <!-- Upload Button -->
      <label class="upload-btn inline-block bg-accent-primary text-white border-2 border-accent-primary 
                    py-2 px-6 text-sm rounded-lg font-semibold cursor-pointer 
                    mb-4 transition duration-300 hover:bg-indigo-600 hover:border-indigo-600">
        <i data-lucide="upload" class="w-4 h-4 inline mr-1"></i> Upload Photo
        <input type="file" name="image" hidden>
      </label>

      <div class="form-box space-y-4">
        
        <!-- Full Name -->
        <div class="form-group">
          <label for="fullname" class="text-text-muted font-medium mb-1 block">Full Name</label>
          <input type="text" id="fullname" name="fullname" value="<?php echo htmlspecialchars($fullname); ?>" placeholder="Enter your full name" class="ultimate-input">
        </div>

        <!-- Username (Read-only) -->
        <div class="form-group">
          <label for="username" class="text-text-muted font-medium mb-1 block">Username (Read-only)</label>
          <input type="text" id="username" value="<?php echo htmlspecialchars($username); ?>" readonly name="username" class="ultimate-input">
        </div>

        <!-- Email (Read-only) -->
        <div class="form-group">
          <label for="email" class="text-text-muted font-medium mb-1 block">Email (Read-only)</label>
          <input type="email" id="email" value="<?php echo htmlspecialchars($email); ?>" readonly name="email" class="ultimate-input">
        </div>

        <!-- Country (Read-only) -->
        <div class="form-group">
          <label for="country" class="text-text-muted font-medium mb-1 block">Country (Read-only)</label>
          <input type="text" id="country" value="<?php echo htmlspecialchars($countryname); ?>" readonly name="country" class="ultimate-input">
        </div>

        <!-- Phone Number -->
        <div class="form-group">
          <label for="phone" class="text-text-muted font-medium mb-1 block">Phone Number</label>
          <input type="tel" id="phone" value="<?php echo htmlspecialchars($phoneNumber); ?>" name="phone" placeholder="+234 or +233" class="ultimate-input">
        </div>
      </div>

      <!-- Update Button -->
      <button type="submit" name="saveProfile" onclick="Request();" 
              class="update-btn bg-accent-gold text-bg-dark border-2 border-accent-gold 
                     py-3 mt-6 w-full font-bold text-lg rounded-xl shadow-lg 
                     transition duration-300 hover:bg-yellow-500 transform hover:scale-[1.01] 
                     flex items-center justify-center">
          <i data-lucide="check-circle" class="w-5 h-5 mr-2"></i> Update Profile
      </button>
    </form>
  </div>
</div>

<script>
    // Initialize Lucide icons on load
    window.onload = function() {
        lucide.createIcons();
    };
    
    // Note: The original script block containing sidebar functions was removed 
    // as it is not present in this specific file and should reside in the included files ('inc/top.php'/'inc/nav.php')
</script>
</body>
</html>
<?php include "inc/nav.php" // Assuming this handles bottom navigation/footer structure ?>