
<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";

$ptitle = "Spin Wheel";
$message = "";
$username = $_SESSION['username'] ?? "";

// ✅ Check if spinwheel is enabled
$getSpin = $link->query("SELECT spinwheel FROM sitedetails LIMIT 1");
$spinEnabled = 0;
if ($getSpin && $getSpin->num_rows > 0) {
    $spinEnabled = (int)$getSpin->fetch_assoc()['spinwheel']; // 1 = enabled, 0 = disabled
}

// Handle spin submission
if(isset($_POST['spin'])) {
    if(!$spinEnabled){ 
        echo json_encode(['message'=>"Spin Wheel Point Accumulation currently unavailable."]);
        exit();
    }

    $score = (float)$_POST['score'];
    $today = date("Y-m-d");

    // Check if user already spun today
    $checkSpin = $link->prepare("SELECT * FROM userearnings WHERE username=? AND type='spin_wheel' AND DATE(date)=?");
    $checkSpin->bind_param("ss", $username, $today);
    $checkSpin->execute();
    $resultSpin = $checkSpin->get_result();

    if($resultSpin->num_rows == 0) {
        // Insert spin result
        $insert = $link->prepare("INSERT INTO userearnings(username, type, amount, date) VALUES (?, 'spin_wheel', ?, NOW())");
        $insert->bind_param("sd", $username, $score);
        $insert->execute();

        // Update user balance
        $update = $link->prepare("UPDATE users SET referralfunds = referralfunds + ? WHERE username=?");
        $update->bind_param("ds", $score, $username);
        $update->execute();

        $message = "You won ₦" . number_format($score, 2) . "! Your balance has been updated.";
    } else {
        $message = "You already spun today. Come back tomorrow!";
    }

    echo json_encode(['message'=>$message]);
    exit();
}

// Check if already spun today for UI
$today = date("Y-m-d");
$checkSpinUI = $link->prepare("SELECT * FROM userearnings WHERE username=? AND type='spin_wheel' AND DATE(date)=?");
$checkSpinUI->bind_param("ss", $username, $today);
$checkSpinUI->execute();
$resultSpinUI = $checkSpinUI->get_result();
$hasSpunToday = ($resultSpinUI->num_rows > 0);
include "inc/top.php"
?>

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<style>
:root {
    --primary-color: red;
    --secondary-color: #16a085;
    --accent-color: #f1c40f;
    --btn-color: #e67e22;
    --text-color: #fff;
    --wheel-bg: linear-gradient(to right, #2c3e50, #34495e);
}
body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: red;
    color: var(--text-color);
    margin: 0;
    padding: 0;
}
h1, h4 { color: var(--accent-color); text-align: center; }
.wheel_box {
    position: relative;
    width: 90%;
    max-width: 320px;
    margin: 2rem auto;
    height: 320px;
    border-radius: 50%;
    overflow: hidden;
    background: #fff2;
    box-shadow: 0 0 20px rgba(0,0,0,0.4);
}
#spinWheel { width: 100%; height: 100%; transform: rotate(270deg); }
#spin_btn {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background-color: var(--btn-color);
    border: none;
    border-radius: 50%;
    width: 80px;
    height: 80px;
    font-size: 1.2rem;
    font-weight: bold;
    color: #fff;
    cursor: pointer;
    box-shadow: 0 5px 15px rgba(0,0,0,0.3);
}
.fa-solid {
    position: absolute;
    top: -10%;
    left: 42%;
    font-size: 2.5rem;
    color: #fff;
}
#text {
    text-align: center;
    margin-top: 1.5rem;
    font-size: 1rem;
    font-weight: 500;
    color: #fff;
}
table.table {
    width: 95%;
    margin: 1rem auto;
    background-color: #fff;
    color: #000;
    border-radius: 0.5rem;
    overflow: hidden;
}
@media(max-width:768px){
    .wheel_box { width: 250px; height: 250px; }
    #spin_btn { width: 60px; height: 60px; font-size: 1rem; }
}
</style>
</head>

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><?php echo $ptitle ?></h4>
    <div class="genMsg"></div>

    <div class="wheel_box">
        <canvas id="spinWheel"></canvas>
        <button id="spin_btn" 
            <?php if($hasSpunToday || !$spinEnabled) echo 'disabled'; ?>>
            <?php 
                if(!$spinEnabled) echo "Disabled";
                else echo $hasSpunToday ? "Spun" : "Spin"; 
            ?>
        </button>
        <i class="fa-solid fa-location-arrow"></i>
    </div>

    <div id="text">
        <p>
        <?php 
        if(!$spinEnabled) echo "Spin Wheel is currently disabled"; 
        else echo $hasSpunToday ? "You already spun today" : "Click the spin button"; 
        ?>
        </p>
    </div>

    <!-- Recent Winnings -->
    <table class="table">
        <thead>
            <tr>
                <th>Id</th>
                <th>Amount</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $sql = $link->prepare("SELECT * FROM userearnings WHERE type='spin_wheel' AND username=? ORDER BY id DESC LIMIT 50");
        $sql->bind_param("s", $username);
        $sql->execute();
        $result = $sql->get_result();
        while($row = $result->fetch_assoc()){
            echo "<tr>
                <td>#".$row['id']."</td>
                <td>₦".number_format($row['amount'],2)."</td>
                <td>".$row['date']."</td>
            </tr>";
        }
        ?>
        </tbody>
    </table>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/chartjs-plugin-datalabels/2.1.0/chartjs-plugin-datalabels.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
const spinWheel = document.getElementById("spinWheel");
const spinBtn = document.getElementById("spin_btn");
const text = document.getElementById("text");

const spinValues = [
    { minDegree: 61, maxDegree: 90, value: 150 },
    { minDegree: 31, maxDegree: 60, value: 0 },
    { minDegree: 0, maxDegree: 30, value: 200 },
    { minDegree: 331, maxDegree: 360, value: 0 },
    { minDegree: 301, maxDegree: 330, value: 300 },
    { minDegree: 271, maxDegree: 300, value: 0 },
    { minDegree: 241, maxDegree: 270, value: 500 },
    { minDegree: 211, maxDegree: 240, value: 0 },
    { minDegree: 181, maxDegree: 210, value: 1000 },
    { minDegree: 151, maxDegree: 180, value: 0 },
    { minDegree: 121, maxDegree: 150, value: 1500 },
    { minDegree: 91, maxDegree: 120, value: 0 },
];

const size = Array(12).fill(3);
const spinColors = ["#e74c3c","#f1c40f","#e74c3c","#f1c40f","#e74c3c","#f1c40f","#e74c3c","#f1c40f","#e74c3c","#f1c40f","#e74c3c","#f1c40f"];

let spinChart = new Chart(spinWheel, {
    plugins: [ChartDataLabels],
    type: "pie",
    data: { labels: [5,0,10,0,50,0,15,0,20,0,30,0], datasets:[{backgroundColor: spinColors, data:size}] },
    options:{
        responsive:true,
        animation:{duration:0},
        plugins:{
            tooltip:false,
            legend:{ display:false },
            datalabels:{
                rotation:90,
                color:"#000",
                formatter: (_, context) => context.chart.data.labels[context.dataIndex],
                font: { size: 12, family: "Arial" }
            }
        }
    }
});

const generateValue = (angleValue) => {
    for(let i of spinValues){
        if(angleValue >= i.minDegree && angleValue <= i.maxDegree){
            let msg = i.value === 0 ? "You won 0 PT 😔" : `Congratulations, You won ${i.value} PT! 🎉`;
            text.innerHTML = `<p>${msg}</p>`;
            submitSpin(i.value);
            break;
        }
    }
}

let count = 0;
let resultValue = 101;
spinBtn?.addEventListener("click", () => {
    spinBtn.disabled = true;
    text.innerHTML = "<p>Spinning...</p>";
    let randomDegree = Math.floor(Math.random() * 356);

    let interval = setInterval(() => {
        spinChart.options.rotation += resultValue;
        spinChart.update();
        if(spinChart.options.rotation >= 360){
            count++;
            resultValue -= 5;
            spinChart.options.rotation = 0;
        } else if(count > 15 && spinChart.options.rotation === randomDegree){
            generateValue(randomDegree);
            clearInterval(interval);
        }
    }, 10);
});

function submitSpin(score){
    $.post("", {spin: true, score: score}, function(data){
        let res = JSON.parse(data);
        alert(res.message);
        location.reload();
    });
}
</script>
<script> 
      // Sidebar toggle
    const body = document.body;
    const menuBtn = document.getElementById('menuBtn');
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');

    function openMenu(){ sidebar.classList.add('open'); overlay.classList.add('show'); body.classList.add('menu-open'); menuBtn.innerHTML = '<i class="bi bi-x-lg"></i>'; }
    function closeMenu(){ sidebar.classList.remove('open'); overlay.classList.remove('show'); body.classList.remove('menu-open'); menuBtn.innerHTML = '<i class="bi bi-list"></i>'; }

    menuBtn.addEventListener('click', () => {
      if(sidebar.classList.contains('open')) closeMenu(); else openMenu();
    });
    overlay.addEventListener('click', closeMenu);
    
    
function openSidebar(){
  document.getElementById("mySidebar").style.left="0px";
  document.getElementById("overlay").style.display="block";
}
function closeSidebar(){
  document.getElementById("mySidebar").style.left="-250px";
  document.getElementById("overlay").style.display="none";
}
function copyRef(){
  const copyText=document.getElementById("refLink");
  copyText.select();
  copyText.setSelectionRange(0,99999);
  document.execCommand("copy");
  const popup=document.getElementById("copyPopup");
  popup.style.display="block";
  setTimeout(()=>{ popup.style.display="none"; },1500);
}
</script>

