<?php 
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/actions/sp-posts.php";

$ptitle="Sponsored Ads"; 
include "inc/top.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">    
  <title><?= htmlspecialchars($ptitle) ?></title>
  
  <!-- Load Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Load Lucide Icons for a clean, modern look -->
  <script src="https://unpkg.com/lucide@latest"></script>
  
  <script>
      // Custom Tailwind Configuration to match the Ultimate Style colors
      tailwind.config = {
          theme: {
              extend: {
                  fontFamily: {
                      sans: ['Inter', 'sans-serif'],
                  },
                  colors: {
                      // ULTIMATE STYLE PALETTE
                      'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                      'card-surface': '#2F1252',   // Slightly Lighter Card Surface
                      'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                      'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                      'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                      'accent-gold': '#FBBF24',    // Gold Accent
                      // Custom colors for actions
                      'cta-share': '#10b981',      // Emerald Green
                      'cta-visit': '#3b82f6',      // Blue
                      'cta-copy': '#FBBF24',       // Yellow/Gold
                      'cta-download': '#a855f7',   // Purple 500
                  }
              }
          }
      }
  </script>
  <style>
    /* Base styles */
    body {
        background-color: #1f083d; /* bg-dark */
        color: #eef2ff; /* text-light */
        font-family: 'Inter', sans-serif;
        margin: 0;
        padding: 0;
    }
    
    /* Custom background for ad image to handle loading/placeholder */
    .ad-image {
        width: 100%;
        padding-top: 60%; /* Aspect ratio 5:3 or similar */
        background-size: cover;
        background-position: center;
        background-color: #2F1252; /* Card surface fallback */
        border-bottom: 2px solid rgba(109, 40, 217, 0.5); /* Accent divider */
    }

    /* Message box styling */
    .response {
        margin: 15px;
        padding: 12px;
        background: #2F1252; /* card-surface */
        border: 1px solid #6d28d9; /* accent-primary */
        border-radius: 8px;
        font-size: 14px;
        color: #A78BFA;
    }

    /* Action button styling using Tailwind colors */
    .action-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        margin: 10px 0;
        padding: 14px;
        font-size: 15px;
        font-weight: bold;
        border-radius: 12px;
        text-decoration: none;
        cursor: pointer;
        transition: all 0.3s ease;
        border: none;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.2);
    }
  </style>
</head>

<body>
<div class="container max-w-lg mx-auto p-4 sm:p-6">

    <!-- Page Title -->
    <div class="page-title text-center mb-6">
        <h3 class="text-3xl font-extrabold text-accent-primary flex items-center justify-center">
            <i data-lucide="megaphone" class="w-7 h-7 mr-3"></i>
            <?php echo $ptitle ?>
        </h3>
    </div>

    <!-- General Message/Response -->
    <div class="response">
        <?php echo $genMsg ?>
    </div>

    <?php if ($numrow_task > 0 && $numrow_userTask == 0): ?>
        
        <!-- Ad Card Container -->
        <div class="card bg-card-surface rounded-xl shadow-2xl border border-accent-primary/50 mb-6 overflow-hidden">
            
            <!-- Ad Image -->
            <div class="ad-image" style="background-image: url('/dash/img/sponsoredposts/<?php echo htmlspecialchars($image) ?>');"></div>
        
            <!-- Ad Content -->
            <div class="content p-5">
                <p class="text-sm font-medium text-text-muted mb-2 flex items-center">
                    <i data-lucide="calendar" class="w-4 h-4 mr-1"></i>
                    <b><?php echo htmlspecialchars($date) ?></b> | Admin
                </p>
                <h2 class="text-xl font-bold text-text-light mb-2"><?php echo htmlspecialchars($title) ?></h2>
                <p class="text-text-light/80"><?php echo htmlspecialchars($desc) ?></p>
            </div>
        </div>

        <!-- Quick Actions Card -->
        <div class="card bg-card-surface p-5 rounded-xl shadow-2xl border border-accent-gold/50">
            <div class="text-lg font-bold text-accent-gold mb-4 border-b border-bg-dark/50 pb-2 flex items-center">
                <i data-lucide="zap" class="w-5 h-5 mr-2"></i>
                Quick Actions
            </div>
            <div class="card-body">
                <small class="text-sm text-text-muted block mb-3">
                    <i data-lucide="info" class="w-4 h-4 inline mr-1 text-accent-primary"></i>
                    <b>Note:</b> Share to WhatsApp status to guarantee payment.
                </small>
                <small class="text-sm text-text-muted block mb-4">
                    <i data-lucide="alert-triangle" class="w-4 h-4 inline mr-1 text-accent-gold"></i>
                    Download the image & copy the text before posting. Failure to do so = no payment.
                </small>

                <!-- Visit Advert Button (Blue) -->
                <a href="<?php echo htmlspecialchars($type) ?>" class="action-btn bg-cta-visit text-text-light hover:bg-blue-600">
                    <i data-lucide="globe" class="w-5 h-5 mr-2"></i> 🌍 Visit Advert
                </a>

                <!-- Share to Earn Button (Green/Emerald) -->
                <form method="POST">
                    <input type="hidden" name="desc" value="<?php echo htmlspecialchars($desc) ?>">
                    <button class="action-btn bg-cta-share text-white hover:bg-emerald-600" name="addTasks" type="submit">
                        <i data-lucide="share-2" class="w-5 h-5 mr-2"></i> 📤 Share to Earn
                    </button>
                </form>

                <!-- Copy Text Button (Yellow/Gold) -->
                <button class="action-btn bg-cta-copy text-bg-dark hover:bg-yellow-400" id="copy-button">
                    <i data-lucide="copy" class="w-5 h-5 mr-2"></i> 📋 Copy Text
                </button>

                <!-- Download Image Button (Purple) -->
                <a href="img/sponsoredposts/<?php echo htmlspecialchars($image) ?>" class="action-btn bg-cta-download text-white hover:bg-purple-600" download>
                    <i data-lucide="download" class="w-5 h-5 mr-2"></i> ⬇ Download Image
                </a>
            </div>
        </div>

    <?php elseif ($numrow_userTask > 0): ?>
        <!-- Completed Message -->
        <div class="card bg-card-surface p-6 rounded-xl shadow-2xl border border-cta-share/50 text-center mt-6">
            <i data-lucide="check-circle" class="w-10 h-10 text-cta-share mb-3 mx-auto"></i>
            <div class="text-xl font-bold text-text-light">
                ✅ You have completed today's sponsored ads.
            </div>
        </div>
    <?php else: ?>
        <!-- Not Yet Out Message -->
        <div class="card bg-card-surface p-6 rounded-xl shadow-2xl border border-text-muted/50 text-center mt-6">
            <i data-lucide="clock" class="w-10 h-10 text-text-muted mb-3 mx-auto"></i>
            <div class="text-xl font-bold text-text-light">
                ⏳ Today's sponsored ads are not yet out.
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Original Scripts preserved -->
<script src="addtasks.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdn.jsdelivr.net/npm/clipboard@2/dist/clipboard.min.js"></script>
<script>
// Initialize Lucide icons on load
window.onload = function() {
    lucide.createIcons();
};

var clipboard = new ClipboardJS('#copy-button', {
    text: function() {
        return <?php echo json_encode($desc); ?>;
    }
});
clipboard.on('success', function() {
    // Replaced original alert with SweetAlert for better aesthetics
    Swal.fire({ 
        title: "Success", 
        text: "Text copied to clipboard.", 
        icon: "success", 
        timer: 2000, 
        showConfirmButton: false 
    });
});
clipboard.on('error', function() {
    // Replaced original alert with SweetAlert for better aesthetics
    Swal.fire({ 
        title: "Error!", 
        text: "Could not copy text.", 
        icon: "error", 
        timer: 2000, 
        showConfirmButton: false 
    });
});
</script> 
<?php include "inc/nav.php" ?>