<?php
// --- ORIGINAL PHP INCLUDES ---
// These files are expected to define database connection ($link), username, and other system variables.
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/actions/tasks.php"; // Assuming this handles the addTask logic

$ptitle = "Daily Tasks";
 include "inc/top.php" // Assuming this handles top navigation/header structure
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($ptitle); ?></title>
    
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Load Lucide Icons for a clean, modern look -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <script>
        // Custom Tailwind Configuration to match the Ultimate Style colors
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        // ULTIMATE STYLE PALETTE
                        'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                        'card-surface': '#2F1252',   // Slightly Lighter Card Surface
                        'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                        'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                        'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                        'accent-gold': '#FBBF24',    // Gold Accent
                        'btn-take': '#10b981',       // Emerald 500 (Green for Action)
                        'btn-claim': '#9333ea',      // Violet 600 (Purple for Claim)
                    }
                }
            }
        }
    </script>
    <style>
        /* Base styles */
        body {
            background-color: #1f083d; /* bg-dark */
            color: #eef2ff; /* text-light */
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
        }
        /* Ensure buttons are properly styled without default browser styles */
        .btn-task {
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px rgba(0,0,0,0.2);
        }
        .btn-task:hover {
            transform: translateY(-1px);
            box-shadow: 0 6px 10px rgba(0,0,0,0.3);
        }
    </style>
</head>
<body>

<div class="container p-4 sm:p-6 max-w-lg mx-auto">

    <!-- Header -->
    <h2 class="text-3xl font-extrabold text-accent-primary mb-8 text-center flex items-center justify-center">
        <i data-lucide="list-checks" class="w-7 h-7 mr-3"></i>
        <?php echo htmlspecialchars($ptitle); ?>
    </h2>

    <?php
    // --- ORIGINAL PHP LOGIC START ---
    
    // NOTE: If the previous includes defined $link and $username, this block will execute the query.
    // If not, it will fail unless $link and $username are mocked or manually defined here.
    
    $date = date("d-m-Y");
    
    // MOCK DATA for demonstration purposes if database connection is unavailable
    // $username = 'user123';
    // $available_tasks = [
    //     [
    //         'description' => 'Watch a 30-second promotional video and rate it 5 stars.', 
    //         'amount' => 500.00,
    //         'reference' => 'TASK-001-VID',
    //         'url' => 'https://example.com/watch/1'
    //     ],
    //     [
    //         'description' => 'Install and test the new companion app (Android only).', 
    //         'amount' => 1250.00,
    //         'reference' => 'TASK-002-APP',
    //         'url' => 'https://example.com/app/android'
    //     ],
    // ];
    // $numrow = count($available_tasks); 
    // $result = new ArrayIterator($available_tasks); // Use ArrayIterator to simulate $result for the loop
    
    // The original logic assumes $link is defined and working:
    $sql = $link->prepare("SELECT * FROM dailytasks WHERE reference NOT IN 
        (SELECT reference FROM usertasks WHERE username=?) 
        AND SUBSTRING(date, 1, 10) = ?");
    $sql->bind_param("ss", $username, $date);
    $sql->execute();
    $result = $sql->get_result();
    $numrow = $result->num_rows;

    if ($numrow > 0) {
        // while ($row = $result->fetch_assoc()) { // Use original fetch_assoc for live data
        // For demonstration with MOCK data: 
        // while ($row = $result->valid() ? $result->current() : null) { $result->next(); 
        
        while ($row = $result->fetch_assoc()) {
            $desc = $row['description']; 
            $amount = $row['amount'];
            $reference = $row['reference'];
            $url = $row['url'];
    ?>
        
        <!-- Task Card (Ultimate Style) -->
        <div class="task-card bg-card-surface p-5 rounded-xl shadow-2xl border border-accent-primary/50 mb-4 transition duration-300 hover:border-accent-gold">
            
            <!-- Description -->
            <div class="flex items-start mb-3">
                <i data-lucide="info" class="w-5 h-5 mr-3 text-text-muted mt-1"></i>
                <p class="text-text-light text-base font-light flex-1">
                    <?php echo htmlspecialchars($desc); ?>
                </p>
            </div>
            
            <!-- Amount -->
            <div class="flex items-center justify-between border-t border-bg-dark/50 pt-3">
                <p class="text-sm text-text-muted">Reward:</p>
                <p class="amount text-accent-gold font-bold text-lg flex items-center">
                    <i data-lucide="dollar-sign" class="w-4 h-4 mr-1"></i> 
                    ₦<?php echo number_format($amount, 2); ?>
                </p>
            </div>

            <div class="task-actions flex gap-3 mt-4">
                
                <!-- 1. Take Task Button (Opens URL in new tab) -->
                <a href="<?php echo htmlspecialchars($url); ?>" target="_blank"
                   class="btn-task btn-take flex-1 text-center py-3 rounded-lg text-white font-semibold flex items-center justify-center bg-btn-take hover:bg-emerald-600 transition duration-300">
                    <i data-lucide="external-link" class="w-4 h-4 mr-2"></i> Take Task
                </a>

                <!-- 2. Claim Task Button (Form Submission) -->
                <form method="POST" class="flex-1">
                    <input name="reference" type="hidden" value="<?php echo htmlspecialchars($reference); ?>">
                    <input name="url" type="hidden" value="<?php echo htmlspecialchars($url); ?>">
                    <button name="addTask" type="submit" 
                            class="btn-task btn-claim w-full py-3 rounded-lg text-white font-semibold flex items-center justify-center bg-btn-claim hover:bg-violet-700 transition duration-300">
                        <i data-lucide="award" class="w-4 h-4 mr-2"></i> Claim Task
                    </button>
                </form>
            </div>
        </div>
    <?php
        }
    } else {
    ?>
        <!-- No task available (Ultimate Style) -->
        <div class="no-task bg-card-surface p-6 rounded-xl shadow-2xl border border-accent-gold/50 text-center mt-10">
            <i data-lucide="sun-off" class="w-10 h-10 text-accent-gold mb-3 mx-auto"></i>
            <p class="text-text-light font-medium text-base">
                No new tasks are available at the moment.
            </p>
            <p class="text-text-muted text-sm mt-1">
                Please check back later to earn more rewards!
            </p>
        </div>
    <?php } 
    // --- ORIGINAL PHP LOGIC END ---
    ?>

</div>

<script>
    // Initialize Lucide icons on load
    window.onload = function() {
        lucide.createIcons();
    };
</script>

</body>
</html>

<?php  include "inc/nav.php" // Assuming this handles bottom navigation/footer structure ?>