<?php ?>
<!doctype html>

<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Coming Soon</title>
  <style>
    :root{
      --red: #b30000;
      --white: #ffffff;
    }
    html,body{
      height:100%;
      margin:0;
      padding:0;
      background:var(--red);
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial;
      color:var(--white);
      -webkit-font-smoothing:antialiased;
      -moz-osx-font-smoothing:grayscale;
    }.wrap{
  min-height:100%;
  display:flex;
  align-items:center;
  justify-content:center;
  padding:28px 20px;
  box-sizing:border-box;
}

.card{
  width:100%;
  max-width:480px;
  text-align:center;
}

.illustration{
  display:block;
  width:85%;
  max-width:420px;
  margin:0 auto 18px auto;
  border-radius:12px;
  box-shadow:0 10px 30px rgba(0,0,0,0.25);
  background:linear-gradient(180deg, rgba(255,255,255,0.02), rgba(0,0,0,0.02));
}

.title{
  font-size:clamp(20px,6vw,36px);
  letter-spacing:1px;
  margin:6px 0 0 0;
  font-weight:700;
}

.subtitle{
  margin:8px 0 0 0;
  font-size:clamp(12px,3.6vw,16px);
  opacity:0.95;
  font-weight:500;
}

/* Make image responsive and ensure it doesn't exceed the card width */
@media (max-width:420px){
  .illustration{ width:92%; }
}

  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <!-- Example online image showing construction/under-construction scene. Replace the URL if you want a different image. -->
      <img class="illustration" src="https://images.unsplash.com/photo-1509395176047-4a66953fd231?auto=format&fit=crop&w=1200&q=80" alt="Under construction illustration" /><h1 class="title">COMING SOON</h1>
  <p class="subtitle">We're working hard to bring something great. Stay tuned.</p>
</div>

  </div>
</body>
</html>