<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";

$message = "";
$color = "red";

if (isset($_POST['upgrade'])) {
    $coupon = trim($_POST['coupon']);

    $stmt = $link->prepare("SELECT * FROM coupons WHERE coupon = ?");
    $stmt->bind_param("s", $coupon);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 0) {
        $message = "Invalid coupon code!";
    } else {
        $row = $result->fetch_assoc();

        if ($row['status'] === "used") {
            $message = "This coupon has already been used!";
        } elseif ($row['type'] !== "plan_a") {
            $message = "This coupon is not for Plan upgrade!";
        } else {
            $updateCoupon = $link->prepare("UPDATE coupons SET status='used' WHERE id=?");
            $updateCoupon->bind_param("i", $row['id']);
            $updateCoupon->execute();

            $updateUser = $link->prepare("UPDATE users SET plantype='plan_a' WHERE username=?");
            $updateUser->bind_param("s", $username);
            $updateUser->execute();

            $message = "✅ Upgrade successful! You are now on pro plan.";
            $color = "green";
        }
    }
} 

include "inc/top.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Upgrade Account</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
      body {
          background: red;
          font-family: Arial, sans-serif;
          margin: 0;
          padding: 0;
          color: white;
      }
      .upgrade-box {
          background: white;
          color: black;
          padding: 18px;
          border-radius: 12px;
          margin: 40px auto;   /* ✅ centers the box */
          width: 95%;          /* ✅ wide on mobile */
          max-width: 600px;    /* ✅ wider than before */
          box-shadow: 0 4px 10px rgba(0,0,0,0.3); 
          text-align: center;
      }
      .upgrade-box h2 {
          margin-bottom: 20px;
          color: #b30000;
      }
      input[type=text] {
          width: 90%;
          padding: 12px;
          margin-bottom: 15px;
          border: 1px solid #ccc;
          border-radius: 8px; 
          text-align: center;
      }
      button {
          width: 90%;
          padding: 12px;
          background: #b30000;
          color: white;
          font-size: 16px;
          border: none;
          border-radius: 8px;
          cursor: pointer;
      }
      button:hover {
          background: #800000;
      }
      .message {
          margin-top: 15px;
          padding: 12px;
          border-radius: 8px;
          text-align: center;
          font-weight: bold;
      }
      .success { background: #4CAF50; color: white; }
      .error { background: #f44336; color: white; }
  </style>
</head>
<body>
  <div class="upgrade-box">
      <h2>Upgrade Your Account</h2>
      <form method="post">
          <input type="text" name="coupon" placeholder="Enter Plan A Coupon Code" required>
          <button type="submit" name="upgrade">Upgrade</button>
      </form>

      <?php if (!empty($message)): ?>
          <div class="message <?php echo ($color=='green') ? 'success' : 'error'; ?>">
              <?php echo $message; ?>
          </div>
      <?php endif; ?>
  </div> 
  <?php include "inc/nav.php" ?>
</body>
</html>