<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";

// ORIGINAL PHP LOGIC: Check for vendor role
if($role != "vendor"){
    header("location:$stream/dash/");
    exit;
}

// ORIGINAL PHP LOGIC: Fetch coupon statistics
$sql=$link->prepare("SELECT * FROM coupons WHERE vendor=?");
$sql->bind_param("s", $username);
$sql->execute();
$result=$sql->get_result();
$totalCoupon=$result->num_rows;

$sql=$link->prepare("SELECT * FROM coupons WHERE vendor=? AND status='used' ");
$sql->bind_param("s", $username);
$sql->execute();
$result=$sql->get_result();
$usedCoupon=$result->num_rows;

$sql=$link->prepare("SELECT * FROM coupons WHERE vendor=? AND status='active' ");
$sql->bind_param("s", $username);
$sql->execute();
$result=$sql->get_result();
$unUsedCoupon=$result->num_rows;


$ptitle="Coupon codes";
include "inc/top.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($ptitle) ?></title>
    
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Load Lucide Icons for a clean, modern look -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <script>
        // Custom Tailwind Configuration to match the Ultimate Style colors
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        // ULTIMATE STYLE PALETTE
                        'bg-dark': '#1f083d',        // Darkest Purple (Primary Dark)
                        'card-surface': '#2F1252',   // Slightly Lighter Card Surface
                        'accent-primary': '#6d28d9', // Indigo 700 (Primary Accent)
                        'text-light': '#eef2ff',     // Indigo 50 (Light Text)
                        'text-muted': '#A78BFA',     // Purple 400 (Muted Text)
                        'accent-gold': '#FBBF24',    // Gold Accent
                    }
                }
            }
        }
    </script>
    <style>
        /* Base styles */
        body {
            background-color: #1f083d; /* bg-dark */
            color: #eef2ff; /* text-light */
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
        }

        /* Card styles */
        .card-style {
            background-color: #2F1252; /* card-surface */
            border-radius: 16px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.4);
        }
        
        /* Table styles */
        .table-custom {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 10px; /* Space between rows */
        }

        .table-custom th {
            text-align: left;
            padding: 12px 10px;
            font-size: 0.8rem;
            color: #A78BFA; /* text-muted */
            font-weight: 600;
            text-transform: uppercase;
        }

        .table-custom td {
            padding: 15px 10px;
            background-color: #1a0631; /* Even darker row background */
            font-size: 0.9rem;
            color: #eef2ff;
            vertical-align: middle;
            border: none;
        }
        
        /* Rounded corners for table rows (first and last cell) */
        .table-custom tbody tr td:first-child {
            border-top-left-radius: 8px;
            border-bottom-left-radius: 8px;
        }
        .table-custom tbody tr td:last-child {
            border-top-right-radius: 8px;
            border-bottom-right-radius: 8px;
        }

        /* Status buttons */
        .btn-status {
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: capitalize;
            border: 1px solid transparent;
            min-width: 75px;
            display: inline-block;
            text-align: center;
        }
        .text-success-custom {
            background-color: rgba(16, 185, 129, 0.2); /* Emerald 500 */
            color: #10b981;
            border-color: #10b981;
        }
        .text-danger-custom {
            background-color: rgba(239, 68, 68, 0.2); /* Red 500 */
            color: #ef4444;
            border-color: #ef4444;
        }
        
        /* Copy button style */
        .btn-copy {
            background-color: #6d28d9; /* accent-primary */
            color: #eef2ff;
            font-weight: bold;
            padding: 10px 15px;
            border-radius: 8px;
            transition: background-color 0.3s;
        }
        .btn-copy:hover {
            background-color: #5b21aa;
        }
    </style>
</head>

<body>
<div class="pt-6 px-4 sm:px-6 max-w-7xl mx-auto">

    <!-- Page Title -->
    <div class="text-center mb-8">
        <h3 class="text-3xl font-extrabold text-accent-primary flex items-center justify-center">
            <i data-lucide="ticket" class="w-7 h-7 mr-3"></i>
            <?= htmlspecialchars($ptitle) ?>
        </h3>
    </div>

    <!-- Stats Card -->
    <div class="card-style shadow-xl p-6 mb-8 border-t-4 border-accent-gold">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 text-center">
            
            <!-- Total Codes -->
            <div class="p-3 bg-bg-dark/50 rounded-lg">
                <p class="text-text-muted text-sm font-medium mb-1">Total Codes</p>
                <h1 class="text-4xl font-extrabold text-accent-gold"><?php echo $totalCoupon ?></h1>
            </div>
            
            <!-- Used Codes -->
            <div class="p-3 bg-bg-dark/50 rounded-lg">
                <p class="text-text-muted text-sm font-medium mb-1">Used Codes</p>
                <h1 class="text-4xl font-extrabold text-[#ef4444]"><?php echo $usedCoupon ?></h1>
            </div>
            
            <!-- Unused Codes -->
            <div class="p-3 bg-bg-dark/50 rounded-lg">
                <p class="text-text-muted text-sm font-medium mb-1">Unused Codes</p>
                <h1 class="text-4xl font-extrabold text-[#10b981]"><?php echo $unUsedCoupon ?></h1>
            </div>
        </div>
    </div>

    <!-- Coupons List Card -->
    <div class="card-style overflow-visible shadow-xl p-0">
        <div class="content p-5">
            <h4 class="text-xl font-bold text-text-light mb-1">All Generated Coupons</h4>
            <p class="text-sm text-text-muted mb-4">Review the status and usage of every code.</p>
            
            <div class="table-responsive w-full overflow-x-auto">
                <table class="table-custom min-w-[700px]">
                    <thead>
                        <tr>
                            <th scope="col" class="w-12">#</th>
                            <th scope="col" class="w-24">Coupon</th>
                            <th scope="col" class="w-20">Status</th>
                            <th scope="col" class="w-32">Generated Date</th>
                            <th scope="col" class="w-40">Used By</th>
                            <th scope="col" class="w-20 text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // ORIGINAL PHP LOGIC: Fetch and display coupon rows
                        $sql = $link->prepare("SELECT * FROM coupons WHERE vendor=? ORDER BY id DESC");
                        $sql->bind_param("s", $username);
                        $sql->execute();
                        $result = $sql->get_result();
                        $numrow = $result->num_rows;

                        if ($numrow > 0) {
                            $id = 0;
                            while ($row = $result->fetch_assoc()) {
                                $id++;
                                $coupon = $row['coupon'];
                                $date = $row['date'];
                                $status = $row['status'];

                                $statusClass = ($status == "used") ? "text-danger-custom" : "text-success-custom";

                                $sql_user = $link->prepare("SELECT * FROM users WHERE coupon=?");
                                $sql_user->bind_param("s", $coupon);
                                $sql_user->execute();
                                $result_user = $sql_user->get_result();
                                $row_user = $result_user->fetch_assoc();
                                $numrow_user = $result_user->num_rows;
                                $usedBy = "N/A";
                                $image = "default.png"; // Placeholder for default image

                                if ($numrow_user == 1) {
                                    $usedBy = $row_user['username'];
                                    $image = $row_user['image'];
                                }
                        ?>
                        <tr>
                            <td>#<?php echo $id; ?></td>
                            <td><code class="font-mono text-sm text-accent-gold"><?php echo htmlspecialchars($coupon); ?></code></td>
                            <td><span class="btn-status <?php echo $statusClass ?>"><?php echo htmlspecialchars($status) ?></span></td>
                            <td><?php echo htmlspecialchars($date) ?></td>
                            <td class="flex items-center">
                                <img src="assets/img/profilephotos/<?php echo htmlspecialchars($image) ?>" width="35" alt="Avatar" class="rounded-full mr-3 object-cover h-9 w-9 border-2 border-text-muted/50"> 
                                <span class="font-medium"><?php echo htmlspecialchars($usedBy) ?></span>
                            </td>
                            <td class="text-center">
                                <button type="button" class="btn-copy copy-coupon" data-coupon="<?php echo htmlspecialchars($coupon) ?>">
                                    <i data-lucide="copy" class="w-4 h-4 inline-block"></i>
                                </button>
                            </td>
                        </tr>
                        <?php
                            }
                        } else {
                            echo "<tr><td colspan='6' class='text-center py-6'>No Coupon Code found.</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    // Initialize Lucide icons on load
    window.onload = function() {
        lucide.createIcons();
    };

    document.addEventListener('DOMContentLoaded', function() {
        // We use a custom modal or library since alert() is forbidden.
        // Since SweetAlert2 was used in the previous file, we'll assume it's available here.
        const copyButtons = document.querySelectorAll('.copy-coupon');
        copyButtons.forEach(button => {
            button.addEventListener('click', function() {
                const couponCode = this.getAttribute('data-coupon');
                navigator.clipboard.writeText(couponCode)
                    .then(() => {
                         // Use SweetAlert for professional notification
                        if (typeof Swal !== 'undefined') {
                            Swal.fire({ 
                                title: "Copied!", 
                                text: `Coupon code ${couponCode} copied to clipboard.`, 
                                icon: "success", 
                                timer: 2000, 
                                showConfirmButton: false 
                            });
                        } else {
                            // Fallback if Swal is not included
                            console.log('Coupon copied to clipboard: ' + couponCode);
                        }
                    })
                    .catch(err => {
                        console.error('Failed to copy coupon: ', err);
                        if (typeof Swal !== 'undefined') {
                             Swal.fire({ 
                                title: "Error!", 
                                text: "Could not copy text.", 
                                icon: "error", 
                                timer: 2000, 
                                showConfirmButton: false 
                            });
                        }
                    });
            });
        });
    });
</script>
<script> 
    // --- ORIGINAL SCRIPT BLOCK (preserved but relies on external HTML structure) ---
    const body = document.body;
    const menuBtn = document.getElementById('menuBtn');
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');

    function openMenu(){ 
      if (sidebar) sidebar.classList.add('open'); 
      if (overlay) overlay.classList.add('show'); 
      body.classList.add('menu-open'); 
      if (menuBtn) menuBtn.innerHTML = '<i class="bi bi-x-lg"></i>'; 
    }
    function closeMenu(){ 
      if (sidebar) sidebar.classList.remove('open'); 
      if (overlay) overlay.classList.remove('show'); 
      body.classList.remove('menu-open'); 
      if (menuBtn) menuBtn.innerHTML = '<i class="bi bi-list"></i>'; 
    }

    if (menuBtn) {
        menuBtn.addEventListener('click', () => {
          if(sidebar && sidebar.classList.contains('open')) closeMenu(); else openMenu();
        });
    }
    if (overlay) overlay.addEventListener('click', closeMenu);
    
    
    function openSidebar(){
      const mySidebar = document.getElementById("mySidebar");
      const overlayEl = document.getElementById("overlay");
      if (mySidebar) mySidebar.style.left="0px";
      if (overlayEl) overlayEl.style.display="block";
    }
    function closeSidebar(){
      const mySidebar = document.getElementById("mySidebar");
      const overlayEl = document.getElementById("overlay");
      if (mySidebar) mySidebar.style.left="-250px";
      if (overlayEl) overlayEl.style.display="none";
    }
    function copyRef(){
      const copyText=document.getElementById("refLink");
      if (!copyText) return;
      copyText
    .select();
      copyText.setSelectionRange(0,99999);
      document.execCommand("copy");
      const popup=document.getElementById("copyPopup");
      if (popup) {
        popup.style.display="block";
        setTimeout(()=>{ popup.style.display="none"; },1500);
      }
    }
    // --- END ORIGINAL SCRIPT BLOCK ---
</script>
<?php include "inc/nav.php" ?>