<?php 
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";

$ptitle="Dashboard";

// ✅ Fetch user info (plan + earnings)
$sql = $link->prepare("SELECT plantype, totalrefearnings, indref FROM users WHERE username=?");
$sql->bind_param('s', $username);
$sql->execute();
$result = $sql->get_result();
if ($result->num_rows == 1) {
    $row = $result->fetch_assoc();
    $userPlan = $row['plantype'];
    $usertotalrefearnings = $row['totalrefearnings'];
    $userIndReferralFunds = $row['indref'];
}

// ✅ AJAX Reward Handling
if (isset($_GET['ajax']) && $_GET['ajax'] === 'reward' && isset($_GET['video_id'])) {
    header('Content-Type: application/json; charset=utf-8');

    $videoId = intval($_GET['video_id']);
    if (!$videoId) { echo json_encode(['success'=>false,'message'=>'Invalid video']); exit; }

    $stmt = $link->prepare("SELECT amount, b_amount, `url`, `video` FROM videos WHERE id=? LIMIT 1");
    $stmt->bind_param("i",$videoId);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows===0) { echo json_encode(['success'=>false,'message'=>'Video not found']); exit; }
    $video = $res->fetch_assoc();

    if ($userPlan === "plan_b") {
        $amount = (float)$video['b_amount'];
    } else {
        $amount = (float)$video['amount'];
    }

    $redirect = $video['url'];

    $stmt = $link->prepare("SELECT 1 FROM video_earning_history WHERE username=? AND video_id=? LIMIT 1");
    $stmt->bind_param("si",$username,$videoId);
    $stmt->execute();
    if ($stmt->get_result()->num_rows>0) { echo json_encode(['success'=>false,'message'=>'Already credited']); exit; }

    $link->begin_transaction();
    try {
        $stmt = $link->prepare("UPDATE users SET referralfunds=referralfunds+? WHERE username=?");
        $stmt->bind_param("ds",$amount,$username);
        $stmt->execute();
        if ($stmt->affected_rows===0) throw new Exception("User not found");

        $stmt = $link->prepare("INSERT INTO video_earning_history(username,video_id,amount,earned_at) VALUES(?,?,?,NOW())");
        $stmt->bind_param("sid",$username,$videoId,$amount);
        $stmt->execute();

        $stmt = $link->prepare("INSERT INTO video_history(username,video_id,watched_at) VALUES(?,?,NOW())");
        $stmt->bind_param("si",$username,$videoId);
        $stmt->execute();

        $link->commit();
        echo json_encode(['success'=>true,'amount'=>$amount,'redirect'=>$redirect]);
    } catch(Exception $e){
        $link->rollback();
        echo json_encode(['success'=>false,'message'=>'Server error']);
    }
    exit;
}

// ==================== FETCH AVAILABLE VIDEOS ====================
$stmt = $link->prepare("SELECT * FROM videos WHERE id NOT IN (SELECT video_id FROM video_earning_history WHERE username=?)");
$stmt->bind_param("s",$username);
$stmt->execute();
$videos = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Watch & Earn</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body{background:darkgreen;color:#fff;font-family:Arial;padding:10px;}
        .video-card{background:rgba(255,255,255,0.12);padding:12px;margin:8px;border-radius:12px;}
        .btn{background:orange;color:black;padding:8px 12px;border:none;border-radius:8px;cursor:pointer;}
        #playerBox{display:none;position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.9);justify-content:center;align-items:center;flex-direction:column;z-index:1000;}
        .video-wrapper{width:90%;max-width:800px;position:relative;padding-top:56.25%;}
        .video-wrapper iframe{position:absolute;top:0;left:0;width:100%;height:100%;border-radius:10px;}
        #message{margin-top:10px;color:#ffeb57;text-align:center;} 
        :root{
          --bg:#0d3d1f; --bg2:#145a2d; --accent:#49b86e; --card:#0f3a20; --text:#f6fff5; --muted:#c7e6d0;
          --soft:#fff4a8; --shadow:0 10px 30px rgba(0,0,0,.35); --danger:#d12; --radius:22px;
        }
        html{scroll-behavior:smooth} *{box-sizing:border-box}
        body{margin:0;font-family:'Inter',system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,'Helvetica Neue',Arial;background:darkgreen; color:var(--text);min-height:100dvh;overflow-x:hidden}
        a{color:inherit;text-decoration:none}
        /* Top, Tabs, Slider, ATM card, Stats, Referral, Bottom nav, Sidebar, Popup */
        /* All your previous CSS remains unchanged */
        .topbar{position:sticky;top:0;z-index:60;padding:14px 16px;display:flex;align-items:center;justify-content:space-between}
.hamburger{width:48px;height:48px;border-radius:50%;display:grid;place-items:center;background:rgba(255,255,255,.06);backdrop-filter:blur(3px);cursor:pointer;transition:.2s}
.hamburger i{font-size:22px}
.avatar{width:48px;height:48px;border-radius:50%;object-fit:cover;border:2px solid rgba(255,255,255,.25);background:#113}


/* Bottom nav */
.bottom-nav{position:fixed;left:12px;right:12px;bottom:12px;background:rgba(0,0,0,.35);backdrop-filter:blur(6px);border:1px solid rgba(255,255,255,.1);border-radius:30px;display:flex;justify-content:space-around;padding:10px 8px;z-index:40}
.b-item{display:grid;place-items:center;gap:4px;padding:6px 10px;border-radius:16px;min-width:70px}
.b-item i{font-size:20px}
.b-item.active{background:rgba(255,255,255,.12)}
.b-item span{font-size:12px}

/* Sidebar */
.overlay{position:fixed;inset:0;background:rgba(0,0,0,.55);backdrop-filter:blur(2px);opacity:0;visibility:hidden;transition:.80s;z-index:80}
.overlay.show{opacity:1;visibility:visible}
.sidebar{position:fixed;inset:12px auto 12px 12px;width:min(86vw,300px);border-radius:30px;background:linear-gradient(160deg,var(--bg2),#0e3b20);border:1px solid rgba(255,255,255,.08);box-shadow:var(--shadow);transform:translateX(-120%);transition:transform .99s ease;z-index:90;display:flex;flex-direction:column;overflow:hidden}
.sidebar.open{transform:translateX(0)}
.sidebar .inner{overflow-y:auto;padding:18px 14px;max-height:100%}
.side-title{display:flex;align-items:center;gap:10px;font-weight:800;margin:4px 6px 14px}
.side-list a{display:flex;align-items:center;gap:14px;padding:12px;border-radius:16px;color:#fff}
.side-list a i{font-size:20px}
.side-list a:hover{background:rgba(255,255,255,.12)}
body.menu-open{overflow:hidden}
    </style>
</head>
<body>
  <!-- Sidebar + Overlay -->
  <div class="overlay" id="overlay"></div>
  <aside class="sidebar" id="sidebar">
    <div class="inner">
      <div class="side-title"><i class="bi bi-grid-1x2"></i> Menu</div>
      <nav class="side-list">
        <a href="index.php" class="active"><i class="bi bi-speedometer2"></i><span>Dashboard</span></a>
        <a href="task.php"><i class="bi bi-check2-square"></i><span>Task</span></a>
        <a href="sppost.php"><i class="bi bi-dice-5"></i><span>Sponsored Post</span></a>
        <a href="airtime.php"><i class="bi bi-phone"></i><span>Airtime</span></a>
        <a href="data.php"><i class="bi bi-wifi"></i><span>Data</span></a>
        <a href="spin.php"><i class="bi bi-dice-5"></i><span>Spin</span></a>
        <a href="watch-history.php"><i class="bi bi-clock-history"></i><span>History</span></a>
        <a href="bank.php"><i class="bi bi-bank"></i><span>Bank</span></a>
        <a href="logout.php"><i class="bi bi-box-arrow-right"></i><span>Logout</span></a>
      </nav>
    </div>
  </aside>  
  
  <!-- Top bar --> 
  <div class="topbar">
    <button class="hamburger" id="menuBtn" aria-label="Open menu"><i class="bi bi-list"></i></button>
    <img src="<?php echo htmlspecialchars($profilePhoto); ?>" class="avatar" alt="profile" onerror="this.src='avatar.png'"/>
  </div>
  
  <small>Welcome, <?php echo htmlspecialchars($username); ?></small>
  <div id="videoList">
      <?php while($v=$videos->fetch_assoc()): ?>
          <?php $rewardAmount = ($userPlan === "plan_b") ? $v['b_amount'] : $v['amount']; ?>
          <div class="video-card" id="card-<?php echo $v['id']; ?>">
              <h3><?php echo htmlspecialchars($v['title']); ?></h3>
              <p><?php echo htmlspecialchars($v['description']); ?></p>
              <strong>Reward:</strong> ₦<?php echo number_format($rewardAmount); ?>
              <br><br>
              <button class="btn" onclick="watchVideo(<?php echo $v['id']; ?>,'<?php echo addslashes($v['video']); ?>','<?php echo addslashes($v['url']); ?>')">Watch Now</button>
          </div>
      <?php endwhile; ?>
      <?php if($videos->num_rows===0): ?>
          <p>No available video now</p>
      <?php endif; ?>
  </div>

  <div id="playerBox">
      <div class="video-wrapper">
          <iframe id="earnVideo" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
      </div>
      <p id="message"></p>
      <button class="btn" onclick="closeVideo()">Close</button>
  </div>
    
  <br><br><br>
  <!-- Bottom nav -->  
  <nav class="bottom-nav">
    <a class="b-item active" href="index.php"><i class="bi bi-house"></i><span>Home</span></a>
    <a class="b-item" href="video.php"><i class="bi bi-collection-play"></i><span>Videos</span></a>
    <a class="b-item" href="withdraw.php"><i class="bi bi-wallet2"></i><span>Withdraw</span></a>
    <a class="b-item" href="setting.php"><i class="bi bi-gear"></i><span>Settings</span></a>
  </nav>

<script src="https://www.youtube.com/iframe_api"></script>
<script>
let currentVideoId = null;
let redirectLink = "";
let ytPlayer = null;
let driveTimer = null;

function watchVideo(id, videoLink, url){
    currentVideoId = id;
    redirectLink = url || "";
    const iframe = document.getElementById("earnVideo");
    const playerBox = document.getElementById("playerBox");
    const msg = document.getElementById("message");

    msg.textContent = "";
    playerBox.style.display = "flex";

    let embedUrl = videoLink;

    // ✅ YouTube (normal + shorts + youtu.be)
    if(videoLink.includes("youtube.com") || videoLink.includes("youtu.be")){
        let videoId = "";
        if(videoLink.includes("youtu.be/")){
            videoId = videoLink.split("youtu.be/")[1].split("?")[0];
        } else if(videoLink.includes("/shorts/")){
            videoId = videoLink.split("/shorts/")[1].split("?")[0];
        } else if(videoLink.includes("v=")){
            videoId = new URL(videoLink).searchParams.get("v");
        }
        if(videoId){
            embedUrl = "https://www.youtube.com/embed/"+videoId+"?enablejsapi=1&autoplay=1";
        }
    }

    // ✅ Google Drive
    if(videoLink.includes("drive.google.com")){
        let match = videoLink.match(/\/d\/(.*?)\//);
        if(match) embedUrl = "https://drive.google.com/file/d/"+match[1]+"/preview";
    }

    iframe.src = embedUrl;

    // ✅ Recreate YT API player
    if(embedUrl.includes("youtube.com/embed")){
        if(ytPlayer) ytPlayer.destroy();
        ytPlayer = new YT.Player("earnVideo", {
            events: { "onStateChange": onYTStateChange }
        });
    } else if(embedUrl.includes("drive.google.com")){
        clearTimeout(driveTimer);
        driveTimer = setTimeout(()=>giveReward(),30000);
    }
}

// ✅ YouTube finished
function onYTStateChange(event){
    if(event.data === YT.PlayerState.ENDED){
        giveReward();
    }
}

// ✅ Reward credit
function giveReward(){
    fetch("?ajax=reward&video_id="+currentVideoId,{credentials:'same-origin'})
    .then(r=>r.json())
    .then(data=>{
        if(data.success){
            document.getElementById("message").textContent = "🎉 +₦"+data.amount;
            const card = document.getElementById("card-"+currentVideoId);
            if(card) card.remove();
            setTimeout(()=>{
                closeVideo();
                if(data.redirect) window.location.href = data.redirect;
                else if(redirectLink) window.location.href = redirectLink;
            },2000);
        } else {
            document.getElementById("message").textContent = "⚠️ "+(data.message||'Error');
        }
    });
}

function closeVideo(){
    const iframe = document.getElementById("earnVideo");
    const playerBox = document.getElementById("playerBox");
    iframe.src="";
    playerBox.style.display="none";
    clearTimeout(driveTimer);
}
</script>

<script>
    // Sidebar toggle
    const body = document.body;
    const menuBtn = document.getElementById('menuBtn');
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');

    function openMenu(){ sidebar.classList.add('open'); overlay.classList.add('show'); body.classList.add('menu-open'); menuBtn.innerHTML = '<i class="bi bi-x-lg"></i>'; }
    function closeMenu(){ sidebar.classList.remove('open'); overlay.classList.remove('show'); body.classList.remove('menu-open'); menuBtn.innerHTML = '<i class="bi bi-list"></i>'; }

    menuBtn.addEventListener('click', () => {
      if(sidebar.classList.contains('open')) closeMenu(); else openMenu();
    });
    overlay.addEventListener('click', closeMenu);
</script>
</body>
</html>