<?php
// --- YOUR REAL BACKEND CONNECTIONS ---
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/dash/actions/withdraw.php";

$ptitle="Request Withdrawal";

// Fetch withdrawals from database
$sql=$link->prepare("SELECT * FROM withdrawals WHERE username=? ORDER BY id DESC");
$sql->bind_param("s", $username);
$sql->execute();
$result = $sql->get_result();
$withdrawals = [];
while ($row = $result->fetch_assoc()) {
    $withdrawals[] = $row;
}

include "inc/top.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($ptitle); ?></title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'bg-dark': '#1f083d',
                        'card-surface': '#2F1252',
                        'accent-primary': '#6d28d9',
                        'accent-gold': '#FBBF24',
                        'text-light': '#eef2ff',
                        'text-muted': '#A78BFA',
                        'status-success': '#10b981',
                        'status-pending': '#FBBF24',
                        'status-rejected': '#ef4444',
                    }
                }
            }
        }
    </script>

    <style>
        body {
            background-color: #1f083d;
            color: #eef2ff;
            font-family: 'Inter', sans-serif;
        }
        .input-field {
            width: 100%;
            padding: 12px;
            margin-top: 8px;
            margin-bottom: 14px;
            border-radius: 10px;
            border: 2px solid #4F1C8B;
            background: #1a0631;
            color: white;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0; top: 0;
            width: 100%; height: 100%;
            background: rgba(0,0,0,0.8);
            justify-content: center;
            align-items: center;
        }
    </style>
</head>

<body>
    <div class="p-4 max-w-lg mx-auto">

        <h2 class="text-3xl font-bold text-accent-primary mb-6 flex items-center">
            <i data-lucide="banknote" class="w-7 h-7 mr-2"></i>
            <?php echo $ptitle ?>
        </h2>

        <!-- SYSTEM MESSAGE -->
        <?php if(!empty($genMsg)): ?>
            <div class="px-4 py-3 mb-4 rounded-lg border 
                <?php echo ($status=='success') 
                    ? 'bg-status-success/20 border-status-success text-status-success' 
                    : 'bg-status-rejected/20 border-status-rejected text-status-rejected'; ?>">
                <?php echo $genMsg ?>
            </div>
        <?php endif; ?>

        <!-- WITHDRAW FORM -->
        <div class="bg-card-surface p-6 rounded-xl shadow-lg border border-accent-primary/40 mb-8">
            <form method="POST">

                <label class="text-text-muted font-medium">Select Wallet</label>
                <select name="wallet" required class="input-field">
                    <option value="">-- Select Wallet --</option>
                    <option value="referral">My wallet</option>
                </select>

                <label class="text-text-muted font-medium">Enter Amount</label>
                <input type="number" name="amount" required class="input-field">

                <input type="hidden" name="countryname" value="<?php echo $countryname ?>">

                <button name="withdraw"
                    class="w-full py-3 bg-accent-primary text-white font-bold rounded-xl hover:bg-indigo-600 transition">
                    <i data-lucide="send" class="w-5 h-5 inline mr-1"></i>
                    Withdraw
                </button>
            </form>
        </div>

        <!-- RECENT WITHDRAWALS -->
        <h3 class="text-xl font-bold mb-4 flex items-center">
            <i data-lucide="clock" class="w-5 h-5 mr-2 text-accent-gold"></i>
            Recent Transactions
        </h3>

        <?php if(count($withdrawals)>0): ?>
            <?php foreach($withdrawals as $w): 
                $status = strtolower($w['status']);
                $border = ($status=='successful'?'status-success':($status=='pending'?'status-pending':'status-rejected'));
                $icon = ($status=='successful'?'check-circle':($status=='pending'?'hourglass':'x-circle'));
            ?>
                <div class="bg-card-surface/70 p-4 rounded-xl mb-3 border-l-4 border-<?php echo $border ?> cursor-pointer list-group-item"
                    data-amount="₦<?php echo number_format($w['amount']) ?>"
                    data-status="<?php echo $status ?>"
                    data-date="<?php echo $w['created_at'] ?>"
                    data-ref="TXN-<?php echo substr(md5($w['id']),0,8) ?>">
                    
                    <span class="font-bold">-₦<?php echo number_format($w['amount']) ?></span>

                    <span class="capitalize font-semibold text-<?php echo $border ?>">
                        <i data-lucide="<?php echo $icon ?>" class="w-4 h-4 inline mr-1"></i>
                        <?php echo $status ?>
                    </span>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="text-text-muted text-center italic">No withdrawals yet.</p>
        <?php endif; ?>
    </div>

    <!-- RECEIPT MODAL -->
    <div id="receiptModal" class="modal">
        <div class="modal-content bg-card-surface p-6 rounded-xl border border-accent-primary max-w-md w-10/12 text-center">
            <h3 class="text-2xl font-bold mb-4 text-accent-primary">Receipt</h3>

            <p><b>Amount:</b> <span id="rAmount"></span></p>
            <p><b>Status:</b> <span id="rStatus" class="font-bold"></span></p>
            <p><b>Date:</b> <span id="rDate"></span></p>
            <p><b>Reference:</b> <span id="rRef"></span></p>

            <button onclick="closeModal()" class="mt-5 py-2 px-6 bg-red-600 rounded-lg text-white font-bold">Close</button>
        </div>
    </div>

    <script>
        const modal = document.getElementById("receiptModal");
        const rAmount = document.getElementById("rAmount");
        const rStatus = document.getElementById("rStatus");
        const rDate = document.getElementById("rDate");
        const rRef = document.getElementById("rRef");

        document.querySelectorAll(".list-group-item").forEach(item => {
            item.onclick = () => {
                rAmount.textContent = item.dataset.amount;
                rStatus.textContent = item.dataset.status;
                rDate.textContent = item.dataset.date;
                rRef.textContent = item.dataset.ref;
                modal.style.display = "flex";
            };
        });

        function closeModal() {
            modal.style.display = "none";
        }

        window.onclick = e => {
            if (e.target == modal) modal.style.display = "none";
        };

        lucide.createIcons();
    </script>

<?php include "inc/nav.php"; ?>