<!-- Footer -->
    <footer class="bg-gray-900 border-t border-indigo-700/50 py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center text-gray-400 text-sm">
            <p>&copy; 2025 Ultimate Platform. All Rights Reserved.</p>
            <p class="mt-2">
                Developer by <a href="https://wa.me/2349056389311" class="text-indigo-400 hover:text-indigo-300 font-semibold transition duration-150" target="_blank">Tboy</a>
            </p>
        </div>
    </footer>

    <!-- JavaScript for Interactivity and Animations -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const menuIcon = document.getElementById('menuIcon');
            const cancelIcon = document.getElementById('cancelIcon');
            const mainHeader = document.getElementById('mainHeader');
            const scrollToTopBtn = document.getElementById('scrollToTopBtn');

            // --- 1. Sidebar Logic ---
            function toggleSidebar() {
                const isHidden = sidebar.classList.contains('translate-x-full');
                if (isHidden) {
                    // Show sidebar
                    sidebar.classList.remove('translate-x-full');
                    sidebarOverlay.classList.remove('hidden');
                    // Fade in overlay (requires a tick for transition)
                    setTimeout(() => sidebarOverlay.style.opacity = '1', 10);
                    // Toggle icons
                    menuIcon.classList.add('hidden');
                    cancelIcon.classList.remove('hidden');
                    document.body.style.overflow = 'hidden'; // Prevent scrolling while open
                } else {
                    // Hide sidebar
                    sidebar.classList.add('translate-x-full');
                    sidebarOverlay.style.opacity = '0';
                    // Hide overlay after transition
                    setTimeout(() => sidebarOverlay.classList.add('hidden'), 400);
                    // Toggle icons
                    menuIcon.classList.remove('hidden');
                    cancelIcon.classList.add('hidden');
                    document.body.style.overflow = '';
                }
            }

            // Bind events
            sidebarToggle.addEventListener('click', toggleSidebar);
            sidebarOverlay.addEventListener('click', toggleSidebar);
            document.querySelectorAll('.sidebar-link').forEach(link => {
                link.addEventListener('click', toggleSidebar); // Close sidebar on link click
            });


            // --- 2. Dynamic Header & Scroll-to-Top Logic ---
            let lastScrollY = window.scrollY;
            const headerHeight = mainHeader.offsetHeight;
            const scrollThreshold = 100; // Distance to scroll down before hiding header/showing button

            window.addEventListener('scroll', () => {
                const currentScrollY = window.scrollY;

                // Sticky Header Logic (Hide on scroll down, show on scroll up)
                if (currentScrollY > lastScrollY && currentScrollY > headerHeight) {
                    // Scrolling down (hide header)
                    mainHeader.classList.add('header-hidden');
                } else if (currentScrollY < lastScrollY) {
                    // Scrolling up (show header)
                    mainHeader.classList.remove('header-hidden');
                }
                lastScrollY = currentScrollY;

                // Scroll-to-Top Button Visibility
                if (currentScrollY > scrollThreshold) {
                    scrollToTopBtn.classList.remove('opacity-0', 'pointer-events-none');
                    scrollToTopBtn.classList.add('opacity-100');
                } else {
                    scrollToTopBtn.classList.add('opacity-0', 'pointer-events-none');
                    scrollToTopBtn.classList.remove('opacity-100');
                }
            });

            // Scroll-to-Top Button Functionality
            scrollToTopBtn.addEventListener('click', () => {
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });
            });


            // --- 3. Reveal Animation Logic (Intersection Observer) ---
            const revealElements = document.querySelectorAll('.reveal-item');
            const observerOptions = {
                root: null,
                rootMargin: '0px',
                threshold: 0.1 // Reveal when 10% of element is visible
            };

            const observer = new IntersectionObserver((entries, observer) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('is-visible');
                        observer.unobserve(entry.target); // Stop observing once visible
                    }
                });
            }, observerOptions);

            // Staggered Initial Load and Scroll Reveal
            revealElements.forEach((el, index) => {
                // Apply a slight stagger delay for the initial top elements
                if (index < 6) { // Stagger first 6 elements on initial load
                    el.style.setProperty('--delay', `${index * 0.1}s`);
                }
                observer.observe(el);
            });
            
            // --- 4. Initialize Lucide Icons ---
            lucide.createIcons();
        });
    </script>

</body>
</html>