<?php	?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ultimate - Monetize Your Influence</title>
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Load Lucide Icons for a clean, modern look -->
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        /* Custom styles for professional appearance and animations */
        :root {
            --primary-dark: #1f083d; /* Darkest Purple */
            --primary-accent: #6d28d9; /* Indigo 700 */
            --text-light: #eef2ff; /* Indigo 50 */
        }
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--primary-dark);
            color: var(--text-light);
        }
        .header-sticky {
            transition: transform 0.3s ease-in-out;
            transform: translateY(0);
        }
        .header-hidden {
            transform: translateY(-100%);
        }
        /* Sidebar transition */
        .sidebar {
            transition: transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        /* Reveal Animation State (for Intersection Observer) */
        .reveal-item {
            opacity: 0;
            transform: translateY(40px);
            transition: opacity 0.6s ease-out, transform 0.6s ease-out;
            transition-delay: var(--delay, 0s); /* For staggered load */
        }

        .reveal-item.is-visible {
            opacity: 1;
            transform: translateY(0);
        }
    </style>
</head>
<body>

    <!-- Scroll-to-Top Button -->
    <button id="scrollToTopBtn" class="fixed bottom-6 right-6 z-50 p-3 bg-indigo-600 hover:bg-indigo-500 rounded-full shadow-lg transition-opacity duration-300 opacity-0 pointer-events-none">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-6 h-6 text-white"><path d="m5 12 7-7 7 7"/><path d="M12 19V5"/></svg>
    </button>

    <!-- Header (Dynamic/Sticky) -->
    <header id="mainHeader" class="header-sticky fixed top-0 left-0 w-full bg-gray-900/95 backdrop-blur-sm shadow-xl z-40 border-b border-indigo-700/50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-16 flex items-center justify-between">
            <!-- Logo (Left) -->
            <a href="#" class="flex items-center space-x-2">
                <!-- Replace with your logo image -->
                <div class="w-8 h-8 bg-indigo-600 rounded-lg flex items-center justify-center font-extrabold text-white text-xl">U</div>
                <span class="text-white text-xl font-bold tracking-wider">ULTIMATE</span>
            </a>

            <!-- Toggle Button (Right) -->
            <button id="sidebarToggle" class="text-indigo-400 hover:text-indigo-200 p-2 rounded-lg transition duration-200">
                <svg id="menuIcon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-6 h-6"><line x1="4" y1="12" x2="20" y2="12"></line><line x1="4" y1="6" x2="20" y2="6"></line><line x1="4" y1="18" x2="20" y2="18"></line></svg>
                <svg id="cancelIcon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-6 h-6 hidden"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
            </button>
        </div>
    </header>

    <!-- Sidebar/Overlay -->
    <div id="sidebarOverlay" class="fixed inset-0 bg-black/50 z-30 hidden transition-opacity duration-300 opacity-0"></div>
    <nav id="sidebar" class="sidebar fixed top-0 right-0 h-full w-64 bg-gray-800 p-6 shadow-2xl z-40 transform translate-x-full">
        <div class="pt-16">
            <h3 class="text-indigo-400 font-semibold mb-6 uppercase tracking-widest text-sm">Navigation</h3>
            <ul class="space-y-3">
                <!-- Clickable Links -->
                <li><a href="index.php" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">Home</a></li>
                <li><a href="#" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">About us</a></li>
                <li><a href="#" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">Run advert</a></li>
                <li><a href="#" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">Contact us</a></li>
                <li><a href="leaderboard.php" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">Top earners</a></li>
                <li class="border-t border-gray-700 pt-3 mt-3"></li>
                <li><a href="coupon-checker.php" class="sidebar-link block text-indigo-400 hover:text-indigo-300 font-bold transition duration-150">Check coupon</a></li>
                <li><a href="vendor.php" class="sidebar-link block text-indigo-400 hover:text-indigo-300 font-bold transition duration-150">Buy coupon</a></li>
                <li><a href="signup.php" class="sidebar-link block text-white bg-indigo-600 hover:bg-indigo-700 px-3 py-1.5 rounded-lg text-center font-bold transition duration-150 mt-4">Register</a></li>
                <li><a href="login.php" class="sidebar-link block text-indigo-600 bg-white hover:bg-gray-100 px-3 py-1.5 rounded-lg text-center font-bold transition duration-150">Login</a></li>
            </ul>
        </div>
    </nav>
