<?php	?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ultimate - Monetize Your Influence</title>
    <!-- Load Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Load Lucide Icons for a clean, modern look -->
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        /* Custom styles for professional appearance and animations */
        :root {
            --primary-dark: #1f083d; /* Darkest Purple */
            --primary-accent: #6d28d9; /* Indigo 700 */
            --text-light: #eef2ff; /* Indigo 50 */
        }
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--primary-dark);
            color: var(--text-light);
        }
        .header-sticky {
            transition: transform 0.3s ease-in-out;
            transform: translateY(0);
        }
        .header-hidden {
            transform: translateY(-100%);
        }
        /* Sidebar transition */
        .sidebar {
            transition: transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        /* Reveal Animation State (for Intersection Observer) */
        .reveal-item {
            opacity: 0;
            transform: translateY(40px);
            transition: opacity 0.6s ease-out, transform 0.6s ease-out;
            transition-delay: var(--delay, 0s); /* For staggered load */
        }

        .reveal-item.is-visible {
            opacity: 1;
            transform: translateY(0);
        }
    </style>
</head>
<body>

    <!-- Scroll-to-Top Button -->
    <button id="scrollToTopBtn" class="fixed bottom-6 right-6 z-50 p-3 bg-indigo-600 hover:bg-indigo-500 rounded-full shadow-lg transition-opacity duration-300 opacity-0 pointer-events-none">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-6 h-6 text-white"><path d="m5 12 7-7 7 7"/><path d="M12 19V5"/></svg>
    </button>

    <!-- Header (Dynamic/Sticky) -->
    <header id="mainHeader" class="header-sticky fixed top-0 left-0 w-full bg-gray-900/95 backdrop-blur-sm shadow-xl z-40 border-b border-indigo-700/50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-16 flex items-center justify-between">
            <!-- Logo (Left) -->
            <a href="#" class="flex items-center space-x-2">
                <!-- Replace with your logo image -->
                <div class="w-8 h-8 bg-indigo-600 rounded-lg flex items-center justify-center font-extrabold text-white text-xl">U</div>
                <span class="text-white text-xl font-bold tracking-wider">ULTIMATE</span>
            </a>

            <!-- Toggle Button (Right) -->
            <button id="sidebarToggle" class="text-indigo-400 hover:text-indigo-200 p-2 rounded-lg transition duration-200">
                <svg id="menuIcon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-6 h-6"><line x1="4" y1="12" x2="20" y2="12"></line><line x1="4" y1="6" x2="20" y2="6"></line><line x1="4" y1="18" x2="20" y2="18"></line></svg>
                <svg id="cancelIcon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-6 h-6 hidden"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
            </button>
        </div>
    </header>

    <!-- Sidebar/Overlay -->
    <div id="sidebarOverlay" class="fixed inset-0 bg-black/50 z-30 hidden transition-opacity duration-300 opacity-0"></div>
    <nav id="sidebar" class="sidebar fixed top-0 right-0 h-full w-64 bg-gray-800 p-6 shadow-2xl z-40 transform translate-x-full">
        <div class="pt-16">
            <h3 class="text-indigo-400 font-semibold mb-6 uppercase tracking-widest text-sm">Navigation</h3>
            <ul class="space-y-3">
                <!-- Clickable Links -->
                <li><a href="index.php" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">Home</a></li>
                <li><a href="#" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">About us</a></li>
                <li><a href="#" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">Run advert</a></li>
                <li><a href="#" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">Contact us</a></li>
                <li><a href="leaderboard.php" class="sidebar-link block text-gray-200 hover:text-indigo-400 font-medium transition duration-150">Top earners</a></li>
                <li class="border-t border-gray-700 pt-3 mt-3"></li>
                <li><a href="coupon-checker.php" class="sidebar-link block text-indigo-400 hover:text-indigo-300 font-bold transition duration-150">Check coupon</a></li>
                <li><a href="vendor.php" class="sidebar-link block text-indigo-400 hover:text-indigo-300 font-bold transition duration-150">Buy coupon</a></li>
                <li><a href="signup.php" class="sidebar-link block text-white bg-indigo-600 hover:bg-indigo-700 px-3 py-1.5 rounded-lg text-center font-bold transition duration-150 mt-4">Register</a></li>
                <li><a href="login.php" class="sidebar-link block text-indigo-600 bg-white hover:bg-gray-100 px-3 py-1.5 rounded-lg text-center font-bold transition duration-150">Login</a></li>
            </ul>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="min-h-[300vh] pt-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">

            <!-- Hero Section (Get Started Button) -->
            <section class="text-center py-20 reveal-item" style="--delay: 0.1s">
                <h1 class="text-5xl md:text-7xl font-extrabold tracking-tight text-white mb-6 leading-tight">
                    <span class="text-indigo-400">ULTIMATE</span> <br>
                    Monetization Platform
                </h1>
                <p class="mt-4 max-w-2xl mx-auto text-lg text-gray-300 font-medium mb-10">
                    Your influence is valuable. Get paid in so many ways: quizzes, tasks, referrals, video views, and social monetization. Start earning today!
                </p>
                <a href="signup.php" class="inline-block bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 px-8 rounded-xl shadow-lg shadow-indigo-500/50 transition duration-300 transform hover:scale-105">
                    GET STARTED NOW
                </a>
            </section>
            
            <!-- Earning Methods Grid -->
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-10 mt-20">

                <!-- Method 1: Quiz Tasks -->
                <div class="reveal-item p-6 rounded-xl bg-gray-800 shadow-xl border border-indigo-700/50" style="--delay: 0.2s">
                    <div class="text-indigo-400 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8"><path d="M14.5 10c-.828.799-.079 3.012-1.921 4.221"/><path d="M12 16.5c-1.325-.367-1.325-2.633 0-3s1.325-2.633 0-3c-1.325-.367-2.65-2.3-3.975-2.667"/></svg>
                    </div>
                    <h2 class="text-xl font-bold text-white mb-2">Quiz Tasks & Surveys</h2>
                    <p class="text-sm font-medium text-gray-400">
                        Engage your brain and get paid. Complete simple quizzes and opinion-based surveys designed to fit your schedule. Fast payouts guaranteed.
                    </p>
                    <div class="mt-4">
                        <img src="https://placehold.co/400x200/220C47/FFFFFF?text=QUIZ+IMAGE" onerror="this.onerror=null;this.src='https://placehold.co/400x200/220C47/FFFFFF?text=QUIZ+TASK';" alt="Quiz task placeholder" class="w-full h-32 object-cover rounded-lg">
                    </div>
                </div>

                <!-- Method 2: Referral Program -->
                <div class="reveal-item p-6 rounded-xl bg-gray-800 shadow-xl border border-indigo-700/50" style="--delay: 0.3s">
                    <div class="text-indigo-400 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8"><path d="M17 18a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2"></path><rect width="18" height="18" x="3" y="4" rx="2"></rect><circle cx="12" cy="10" r="2"></circle><line x1="12" y1="2" x2="12" y2="4"></line></svg>
                    </div>
                    <h2 class="text-xl font-bold text-white mb-2">High-Tier Referral System</h2>
                    <p class="text-sm font-medium text-gray-400">
                        Share your unique link and earn recurring commissions. The more successful users you bring, the higher your earning multiplier. Passive income made easy.
                    </p>
                    <div class="mt-4">
                        <img src="https://placehold.co/400x200/220C47/FFFFFF?text=REFERRAL+FLYER" onerror="this.onerror=null;this.src='https://placehold.co/400x200/220C47/FFFFFF?text=REFERRAL+SYSTEM';" alt="Referral flyer placeholder" class="w-full h-32 object-cover rounded-lg">
                    </div>
                </div>

                <!-- Method 3: Video Engagement -->
                <div class="reveal-item p-6 rounded-xl bg-gray-800 shadow-xl border border-indigo-700/50" style="--delay: 0.4s">
                    <div class="text-indigo-400 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M23 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                    </div>
                    <h2 class="text-xl font-bold text-white mb-2">Video & Content View</h2>
                    <p class="text-sm font-medium text-gray-400">
                        Watch short, curated video content or view sponsored posts and get credited instantly. Simple, passive, and accessible monetization for everyone.
                    </p>
                    <div class="mt-4">
                        <img src="https://placehold.co/400x200/220C47/FFFFFF?text=VIDEO+CONTENT" onerror="this.onerror=null;this.src='https://placehold.co/400x200/220C47/FFFFFF?text=VIDEO+TASK';" alt="Video content placeholder" class="w-full h-32 object-cover rounded-lg">
                    </div>
                </div>

                <!-- Method 4: Sharing Posts -->
                <div class="reveal-item p-6 rounded-xl bg-gray-800 shadow-xl border border-indigo-700/50" style="--delay: 0.5s">
                    <div class="text-indigo-400 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8"><path d="M18 8h1a4 4 0 0 1 0 8h-1"></path><path d="M2 8h16"></path><path d="M2 16h16"></path><path d="M8 8V6a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><path d="M8 16v2a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-2"></path></svg>
                    </div>
                    <h2 class="text-xl font-bold text-white mb-2">Social Post Sharing</h2>
                    <p class="text-sm font-medium text-gray-400">
                        Amplify brand messages directly from your dashboard to your social media profiles. Earn per share and per engagement that your post generates.
                    </p>
                    <div class="mt-4">
                        <img src="https://placehold.co/400x200/220C47/FFFFFF?text=SOCIAL+SHARE" onerror="this.onerror=null;this.src='https://placehold.co/400x200/220C47/FFFFFF?text=POST+SHARING';" alt="Social post sharing placeholder" class="w-full h-32 object-cover rounded-lg">
                    </div>
                </div>

                <!-- Method 5: Social Monetization -->
                <div class="reveal-item p-6 rounded-xl bg-gray-800 shadow-xl border border-indigo-700/50" style="--delay: 0.6s">
                    <div class="text-indigo-400 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8"><path d="M4 12v8a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-8"></path><polyline points="16 6 12 2 8 6"></polyline><line x1="12" y1="2" x2="12" y2="17"></line></svg>
                    </div>
                    <h2 class="text-xl font-bold text-white mb-2">Influence Conversion</h2>
                    <p class="text-sm font-medium text-gray-400">
                        Connect your social accounts and monetize your existing audience. Get paid for unique clicks, impressions, and tailored calls to action.
                    </p>
                    <div class="mt-4">
                        <img src="https://placehold.co/400x200/220C47/FFFFFF?text=INFLUENCE+MONEY" onerror="this.onerror=null;this.src='https://placehold.co/400x200/220C47/FFFFFF?text=SOCIAL+INFLUENCE';" alt="Influence monetization placeholder" class="w-full h-32 object-cover rounded-lg">
                    </div>
                </div>
            </div>

            <!-- Long Content Section (Scroll-Reveal Areas) -->
            
            <section class="mt-24 py-12 border-t border-indigo-700/30">
                <h2 class="text-3xl font-bold text-indigo-400 mb-10 text-center reveal-item">Why Ultimate is Different</h2>
                
                <!-- Section 1: Transparency -->
                <div class="md:flex items-center space-y-8 md:space-y-0 md:space-x-12 mb-16">
                    <div class="md:w-1/2 reveal-item">
                        <img src="https://placehold.co/600x400/220C47/FFFFFF?text=TRANSPARENCY" onerror="this.onerror=null;this.src='https://placehold.co/600x400/220C47/FFFFFF?text=TRANSPARENCY';" alt="Transparency illustration" class="w-full h-64 object-cover rounded-xl shadow-lg shadow-indigo-500/30">
                    </div>
                    <div class="md:w-1/2 reveal-item">
                        <h3 class="text-2xl font-bold text-white mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 text-indigo-400 mr-2"><circle cx="12" cy="12" r="10"></circle><path d="M12 16v-4"></path><path d="M12 8h.01"></path></svg>
                            Complete Earning Transparency
                        </h3>
                        <p class="text-sm font-medium text-gray-400 leading-relaxed">
                            Every task, every referral, and every click is tracked and displayed in real-time on your dashboard. We offer crystal-clear reporting so you always know exactly where your income comes from. There are no hidden fees or vague payout structures. Our system is built on trust, giving you the confidence to focus purely on growing your earnings without any doubt about your performance metrics.
                        </p>
                    </div>
                </div>

                <!-- Section 2: Global Reach -->
                <div class="md:flex flex-row-reverse items-center space-y-8 md:space-y-0 md:space-x-12 md:space-x-reverse mb-16">
                    <div class="md:w-1/2 reveal-item">
                        <img src="https://placehold.co/600x400/220C47/FFFFFF?text=GLOBAL+REACH" onerror="this.onerror=null;this.src='https://placehold.co/600x400/220C47/FFFFFF?text=GLOBAL+REACH';" alt="Global reach illustration" class="w-full h-64 object-cover rounded-xl shadow-lg shadow-indigo-500/30">
                    </div>
                    <div class="md:w-1/2 reveal-item">
                        <h3 class="text-2xl font-bold text-white mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 text-indigo-400 mr-2"><path d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10z"></path><line x1="2" y1="12" x2="22" y2="12"></line><path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path></svg>
                            Monetization with Global Opportunities
                        </h3>
                        <p class="text-sm font-medium text-gray-400 leading-relaxed">
                            Ultimate sources earning opportunities from international partners, ensuring a steady stream of high-value tasks regardless of your geographical location. Our multi-currency support and flexible withdrawal options mean your earnings are maximized and accessible when you need them. Expand your horizon with global earning power.
                        </p>
                    </div>
                </div>

                <!-- Section 3: User Growth & Support -->
                <div class="md:flex items-center space-y-8 md:space-y-0 md:space-x-12">
                    <div class="md:w-1/2 reveal-item">
                        <img src="https://placehold.co/600x400/220C47/FFFFFF?text=SUPPORT" onerror="this.onerror=null;this.src='https://placehold.co/600x400/220C47/FFFFFF?text=SUPPORT';" alt="Support illustration" class="w-full h-64 object-cover rounded-xl shadow-lg shadow-indigo-500/30">
                    </div>
                    <div class="md:w-1/2 reveal-item">
                        <h3 class="text-2xl font-bold text-white mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 text-indigo-400 mr-2"><path d="M12 20h0v0"></path><path d="M12 14v-4"></path><path d="M12 2a10 10 0 1 0 0 20 10 10 0 0 0 0-20z"></path></svg>
                            Dedicated User Growth Support
                        </h3>
                        <p class="text-sm font-medium text-gray-400 leading-relaxed">
                            We don't just provide tasks; we provide the knowledge to succeed. Access exclusive tutorials on maximizing referral gains, optimizing social posts for monetization, and getting higher scores on quizzes. Our dedicated support team is available 24/7 to ensure your journey to financial freedom is smooth and successful.
                        </p>
                    </div>
                </div>
            </section>
        </div>

        <!-- Call to Action Banner -->
        <div class="bg-indigo-700 py-16 mt-20 reveal-item">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h2 class="text-4xl font-extrabold text-white mb-4">Ready to Unlock Your Ultimate Income?</h2>
                <p class="text-lg text-indigo-200 mb-8 font-medium">Join thousands of successful earners today and convert your screen time into real profit.</p>
                <a href="signup.php" class="inline-block bg-white hover:bg-gray-100 text-indigo-700 font-bold py-3 px-10 rounded-xl shadow-2xl transition duration-300 transform hover:scale-105">
                    REGISTER NOW & GET STARTED
                </a>
            </div>
        </div>

    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 border-t border-indigo-700/50 py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center text-gray-400 text-sm">
            <p>&copy; 2025 Ultimate Platform. All Rights Reserved.</p>
            <p class="mt-2">
                Developer by <a href="https://wa.me/2349056389311" class="text-indigo-400 hover:text-indigo-300 font-semibold transition duration-150" target="_blank">Tboy</a>
            </p>
        </div>
    </footer>

    <!-- JavaScript for Interactivity and Animations -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const menuIcon = document.getElementById('menuIcon');
            const cancelIcon = document.getElementById('cancelIcon');
            const mainHeader = document.getElementById('mainHeader');
            const scrollToTopBtn = document.getElementById('scrollToTopBtn');

            // --- 1. Sidebar Logic ---
            function toggleSidebar() {
                const isHidden = sidebar.classList.contains('translate-x-full');
                if (isHidden) {
                    // Show sidebar
                    sidebar.classList.remove('translate-x-full');
                    sidebarOverlay.classList.remove('hidden');
                    // Fade in overlay (requires a tick for transition)
                    setTimeout(() => sidebarOverlay.style.opacity = '1', 10);
                    // Toggle icons
                    menuIcon.classList.add('hidden');
                    cancelIcon.classList.remove('hidden');
                    document.body.style.overflow = 'hidden'; // Prevent scrolling while open
                } else {
                    // Hide sidebar
                    sidebar.classList.add('translate-x-full');
                    sidebarOverlay.style.opacity = '0';
                    // Hide overlay after transition
                    setTimeout(() => sidebarOverlay.classList.add('hidden'), 400);
                    // Toggle icons
                    menuIcon.classList.remove('hidden');
                    cancelIcon.classList.add('hidden');
                    document.body.style.overflow = '';
                }
            }

            // Bind events
            sidebarToggle.addEventListener('click', toggleSidebar);
            sidebarOverlay.addEventListener('click', toggleSidebar);
            document.querySelectorAll('.sidebar-link').forEach(link => {
                link.addEventListener('click', toggleSidebar); // Close sidebar on link click
            });


            // --- 2. Dynamic Header & Scroll-to-Top Logic ---
            let lastScrollY = window.scrollY;
            const headerHeight = mainHeader.offsetHeight;
            const scrollThreshold = 100; // Distance to scroll down before hiding header/showing button

            window.addEventListener('scroll', () => {
                const currentScrollY = window.scrollY;

                // Sticky Header Logic (Hide on scroll down, show on scroll up)
                if (currentScrollY > lastScrollY && currentScrollY > headerHeight) {
                    // Scrolling down (hide header)
                    mainHeader.classList.add('header-hidden');
                } else if (currentScrollY < lastScrollY) {
                    // Scrolling up (show header)
                    mainHeader.classList.remove('header-hidden');
                }
                lastScrollY = currentScrollY;

                // Scroll-to-Top Button Visibility
                if (currentScrollY > scrollThreshold) {
                    scrollToTopBtn.classList.remove('opacity-0', 'pointer-events-none');
                    scrollToTopBtn.classList.add('opacity-100');
                } else {
                    scrollToTopBtn.classList.add('opacity-0', 'pointer-events-none');
                    scrollToTopBtn.classList.remove('opacity-100');
                }
            });

            // Scroll-to-Top Button Functionality
            scrollToTopBtn.addEventListener('click', () => {
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });
            });


            // --- 3. Reveal Animation Logic (Intersection Observer) ---
            const revealElements = document.querySelectorAll('.reveal-item');
            const observerOptions = {
                root: null,
                rootMargin: '0px',
                threshold: 0.1 // Reveal when 10% of element is visible
            };

            const observer = new IntersectionObserver((entries, observer) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('is-visible');
                        observer.unobserve(entry.target); // Stop observing once visible
                    }
                });
            }, observerOptions);

            // Staggered Initial Load and Scroll Reveal
            revealElements.forEach((el, index) => {
                // Apply a slight stagger delay for the initial top elements
                if (index < 6) { // Stagger first 6 elements on initial load
                    el.style.setProperty('--delay', `${index * 0.1}s`);
                }
                observer.observe(el);
            });
            
            // --- 4. Initialize Lucide Icons ---
            lucide.createIcons();
        });
    </script>

</body>
</html>