<?php 
error_reporting(E_ALL);
ini_set('display_errors', '1');

require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/actions/formprocess.php";

$ptitle = "Top Earners";
// Original includes are maintained
include "inc/top.php"; 
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Top Earners - Leaderboard</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Bootstrap Icons CDN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'background-dark': '#0f172a', // Slate 900
                        'card-medium': '#1e293b', // Slate 800
                        'accent-gold': '#fbbf24', // Amber 400 (for highlight)
                        'text-light': '#f1f5f9', // Slate 100
                    }
                }
            }
        }
    </script>
    <style>
        /* Ensures full mobile view, overrides the PHP include style */
       /* body {
            background-color: #0f172a;
            color: #f1f5f9;
            min-height: 100vh;
            padding: 0;
            margin: 0;
            font-family: 'Inter', sans-serif;
            padding-bottom: 70px; /* Space for the footer/bottom nav */
        }*/
        /* Style for the Rank Badge */
        .rank-badge {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            font-weight: 800;
            flex-shrink: 0;
            border-radius: 50%;
            background-color: #334155; /* Slate 700 */
            color: #fff;
            font-size: 1rem;
            transition: all 0.3s;
        }

        /* Specific styles for Top 3 ranks */
        .rank-1 {
            background: linear-gradient(135deg, #fbbf24, #f59e0b);
            color: #1e293b;
            box-shadow: 0 4px 10px rgba(251, 191, 36, 0.4);
            font-size: 1.15rem;
            transform: scale(1.1);
        }
        .rank-2 {
            background: linear-gradient(135deg, #94a3b8, #64748b);
            color: #1e293b;
            box-shadow: 0 4px 8px rgba(100, 116, 139, 0.4);
        }
        .rank-3 {
            background: linear-gradient(135deg, #b45309, #7c2d12);
            color: #1e293b;
            box-shadow: 0 4px 8px rgba(180, 83, 9, 0.4);
        }

        /* Profile image fallback style */
        .profile-img {
            object-fit: cover;
            width: 100%;
            height: 100%;
        }

        /* Card hover effect for better touch feedback */
        .earner-card:active {
            transform: scale(0.98);
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.4);
        }
    </style>
</head>

<body>
    <br><br>
    
    <div class="pt-10 px-4 max-w-xl mx-auto">
        
        <!-- Header Section -->
        <div class="text-center mb-8">
            <i class="bi bi-trophy-fill text-accent-gold text-4xl mb-2"></i>
            <h1 class="text-3xl font-extrabold text-text-light tracking-tight">Leaderboard: Top Earners</h1>
            <p class="text-slate-400 mt-1 text-sm">See who's dominating the referral earnings this month.</p>
        </div>

        <!-- Leaderboard List -->
        <div class="space-y-4">
            <?php
            // PHP logic to fetch data
            $sql = "SELECT * FROM users WHERE totalrefearnings > 0 ORDER BY CAST(totalrefearnings AS UNSIGNED) DESC LIMIT 20";
            $result = $link->query($sql);

            if ($result->num_rows > 0) {
                $rank = 1;
                while ($row = $result->fetch_assoc()) {
                    
                    // Determine rank-specific classes
                    $rankClass = '';
                    if ($rank === 1) {
                        $rankClass = 'rank-1';
                    } elseif ($rank === 2) {
                        $rankClass = 'rank-2';
                    } elseif ($rank === 3) {
                        $rankClass = 'rank-3';
                    }

                    // Set image source logic
                    $image_src = ($row["image"] == "no-avatar.png") 
                                 ? "structure.jpg" // Fallback image path
                                 : "dash/assets/img/profilephotos/" . $row["image"];
                                 
                    ?>
                    
                    <!-- Earner Card -->
                    <div class="earner-card bg-card-medium rounded-2xl p-4 flex items-center shadow-lg transition duration-200">
                        
                        <!-- Rank Badge -->
                        <div class="rank-badge mr-4 <?php echo $rankClass; ?>">
                            <?php echo $rank; ?>
                        </div>

                        <!-- Profile Picture -->
                        <div class="w-12 h-12 rounded-full overflow-hidden mr-4 border-2 border-slate-600 flex-shrink-0">
                            <img class="profile-img" src="<?php echo htmlspecialchars($image_src); ?>" alt="<?php echo htmlspecialchars($row["username"]); ?>'s Profile">
                        </div>

                        <!-- Username + Earnings -->
                        <div class="flex-grow min-w-0">
                            <h3 class="text-lg font-bold text-text-light truncate lowercase">
                                <?php echo htmlspecialchars($row["username"]); ?>
                            </h3>
                            <!-- Accent color for earnings -->
                            <p class="text-sm font-extrabold text-accent-gold mt-0.5">
                                ₦<?php echo number_format((int)$row["totalrefearnings"]); ?>
                            </p>
                        </div>
                        
                        <!-- Action Icon (optional but looks good) -->
                        <div class="ml-4 text-slate-400">
                            <i class="bi bi-currency-dollar text-xl"></i>
                        </div>

                    </div>
                    
                    <?php
                    $rank++;
                }
            } else {
                // No earners message
                echo '<div class="text-center p-8 bg-card-medium rounded-xl text-slate-400">';
                echo '<i class="bi bi-emoji-frown text-3xl mb-3 block"></i>';
                echo '<p class="font-semibold">No earners found yet! Time to start referring.</p>';
                echo '</div>';
            }
            ?>
        </div>
        
    </div>
    <br><br>

    <?php
    // Original include is maintained
    include "inc/buttom.php" 
    ?>
</body>
</html>