<?php   
require $_SERVER['DOCUMENT_ROOT']."/stream.php";  
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";  
require $_SERVER['DOCUMENT_ROOT']."$stream/actions/formprocess.php";  

$ptitle = "Login";  
?>  

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ultimate Login - Secure Access</title>
    
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Bootstrap Icons CDN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        // ULTIMATE DARK THEME PALETTE
                        'bg-primary-dark': '#0F031F', 
                        'card-purple': '#1A0A38', 
                        'accent-indigo': '#6366f1', // Indigo 500
                        'accent-indigo-light': '#a5b4fc', // Indigo 300
                    }
                }
            }
        }
    </script>
    <style>
        /* Custom styles for dramatic depth and focus */
        .ultimate-gradient {
            background-color: #0F031F;
            background-image: radial-gradient(at 0% 0%, rgba(99, 102, 241, 0.15) 0%, transparent 50%),
                              radial-gradient(at 100% 100%, rgba(99, 102, 241, 0.1) 0%, transparent 50%);
        }
        .form-input-container {
            position: relative;
        }
        .form-input-icon {
            position: absolute;
            left: 0.75rem;
            top: 50%;
            transform: translateY(-50%);
            color: #9CA3AF; /* gray-400 */
        }
        input:focus {
            outline: none;
            /* Accent focus glow */
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.5); 
        }
    </style>
</head>

<body class="ultimate-gradient min-h-screen flex items-center justify-center p-4 font-sans">
  
    <div class="w-full max-w-md mx-auto bg-card-purple rounded-3xl shadow-[0_15px_30px_-5px_rgba(0,0,0,0.5)] p-8 md:p-12 border border-indigo-700/50">
        
        <!-- Logo & Header -->
        <div class="text-center mb-8">
            <!-- Ultimate Icon Styling -->
            <div class="w-20 h-20 bg-accent-indigo/20 rounded-2xl mx-auto flex items-center justify-center mb-4 shadow-xl">
                 <i class="bi bi-person-lock text-accent-indigo text-4xl"></i>
            </div>
            <h1 class="text-3xl font-extrabold text-white tracking-wide">WELCOME TO ULTIMATE</h1>
            <p class="text-indigo-300 mt-1 font-medium">Log in to manage your earnings and tasks.</p>
        </div>

        <!-- System Message Area -->
        <div class="mb-6">
            <?php if($genMsg != ""): ?>
                <!-- Improved contrast for success/error messages -->
                <div class="p-4 rounded-xl font-semibold text-sm shadow-md 
                    <?php echo ($status == 'success') ? 'bg-green-800/50 text-green-300 border border-green-700' : 'bg-red-800/50 text-red-300 border border-red-700'; ?>">
                    <?php echo $genMsg; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Form -->
        <form method="POST" id="loginForm" class="space-y-6">
            
            <!-- Username/Email -->
            <div class="form-input-container">
                <i class="bi bi-person-fill form-input-icon"></i>
                <label for="username" class="sr-only">Username or Email</label>
                <input type="text" id="username" name="username" value="<?php echo $username; ?>" placeholder="Username or Email" required
                       class="w-full pl-10 pr-4 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl placeholder-indigo-300/50 focus:border-accent-indigo transition duration-200 shadow-inner">
            </div>

            <!-- Password -->
            <div class="form-input-container">
                <i class="bi bi-lock-fill form-input-icon"></i>
                <label for="password" class="sr-only">Password</label>
                <input type="password" id="password" name="password" placeholder="Enter your password" required
                       class="w-full pl-10 pr-10 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl placeholder-indigo-300/50 focus:border-accent-indigo transition duration-200 shadow-inner">
                
                <!-- Password Toggle Icon -->
                <span class="absolute right-3 top-1/2 transform -translate-y-1/2 text-indigo-400 cursor-pointer hover:text-white transition duration-200" onclick="togglePassword()">
                    <i id="togglePassword" class="bi bi-eye-slash-fill"></i>
                </span>
            </div>

            <!-- Forgot Password Link -->
            <div class="text-right">
                <a href="forgot_password.php" class="text-xs text-accent-indigo-light hover:text-white font-medium transition duration-150">
                    Forgot Password?
                </a>
            </div>

            <!-- Submit Button (Dramatic Style) -->
            <button name="login" type="submit" 
                    class="w-full py-4 bg-accent-indigo text-white font-extrabold text-lg rounded-xl shadow-lg shadow-indigo-500/50 hover:bg-indigo-600 transition duration-300 transform hover:scale-[1.01] focus:outline-none focus:ring-4 focus:ring-indigo-500/70 mt-8 uppercase tracking-wider">
                <i class="bi bi-box-arrow-in-right mr-2"></i> ACCESS DASHBOARD
            </button>
        </form>

        <!-- Bottom Link -->
        <div class="mt-6 text-center text-gray-400 text-sm">
            Don't have an Ultimate account? <a class="text-accent-indigo-light hover:text-white font-bold transition duration-150" href="signup.php">Sign Up Now</a>
        </div>
    </div>

    <!-- JavaScript for Password Toggle -->
    <script>
        function togglePassword() {
            const passField = document.getElementById("password");
            const toggleIcon = document.getElementById("togglePassword");

            if (passField.type === "password") {
                passField.type = "text";
                toggleIcon.classList.remove('bi-eye-slash-fill');
                toggleIcon.classList.add('bi-eye-fill');
            } else {
                passField.type = "password";
                toggleIcon.classList.remove('bi-eye-fill');
                toggleIcon.classList.add('bi-eye-slash-fill');
            }
        }
    </script>
</body>
</html>