<?php 
error_reporting(E_ALL);
ini_set('display_errors', 1);
// These require paths are kept exactly as they were in the original file
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/actions/formprocess.php";
include_once $_SERVER['DOCUMENT_ROOT']."$stream/includes/sendmail.php";

$isReferral = false;
$refUsername = "";
if (isset($_GET['ref'])) {
    $isReferral = true;
    $refUsername = $_GET['ref'];
}

$ptitle = "Signup";

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ultimate Registration - Join Now</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Bootstrap Icons CDN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        // ULTIMATE DARK THEME PALETTE
                        'bg-primary-dark': '#0F031F', 
                        'card-purple': '#1A0A38', 
                        'accent-indigo': '#6366f1', // Indigo 500
                        'accent-indigo-light': '#a5b4fc', // Indigo 300
                    }
                }
            }
        }
    </script>
    <style>
        /* Custom styles for dramatic depth and focus */
        .ultimate-gradient {
            background-color: #0F031F;
            background-image: radial-gradient(at 0% 0%, rgba(99, 102, 241, 0.15) 0%, transparent 50%),
                              radial-gradient(at 100% 100%, rgba(99, 102, 241, 0.1) 0%, transparent 50%);
        }
        input:focus, select:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.5); /* Accent focus glow */
        }
        .form-input-icon {
            position: absolute;
            left: 0.75rem;
            top: 50%;
            transform: translateY(-50%);
            color: #9CA3AF; /* gray-400 */
        }
    </style>
</head>
<body class="ultimate-gradient min-h-screen flex items-center justify-center p-4 font-sans">

    <div class="w-full max-w-md mx-auto bg-card-purple rounded-3xl shadow-[0_15px_30px_-5px_rgba(0,0,0,0.5)] p-8 md:p-12 border border-indigo-700/50">
        
        <!-- Logo & Header -->
        <div class="text-center mb-8">
            <!-- Ultimate Icon Styling -->
            <div class="w-24 h-24 bg-accent-indigo/20 rounded-2xl mx-auto flex items-center justify-center mb-4 shadow-xl">
                 <i class="bi bi-person-plus-fill text-accent-indigo text-4xl"></i>
            </div>
            <h1 class="text-4xl font-extrabold text-white tracking-wide">ULTIMATE REGISTRATION</h1>
            <p class="text-indigo-300 mt-2 font-medium">Join the platform to start maximizing your earnings.</p>
        </div>

        <!-- System Message Area -->
        <div class="mb-6">
            <?php if($genMsg != ""): ?>
                <!-- Improved contrast for success/error messages -->
                <div class="p-4 rounded-xl font-semibold text-sm shadow-md 
                    <?php echo ($status == 'success') ? 'bg-green-800/50 text-green-300 border border-green-700' : 'bg-red-800/50 text-red-300 border border-red-700'; ?>">
                    <?php echo $genMsg; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Form -->
        <form method="POST" id="signupForm" class="space-y-5">
            
            <!-- Username -->
            <div class="relative">
                <i class="bi bi-person-circle form-input-icon"></i>
                <label for="username" class="sr-only">Username</label>  
                <input type="text" name="username" value="<?php echo $username; ?>" placeholder="Choose a Username" required
                       class="w-full pl-10 pr-4 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl placeholder-indigo-300/50 focus:border-accent-indigo transition duration-200 shadow-inner">
            </div>

            <!-- Full Name -->
            <div class="relative">
                <i class="bi bi-file-person-fill form-input-icon"></i>
                <label for="fullname" class="sr-only">Full Name</label>
                <input type="text" name="fullname" value="<?php echo $fullname; ?>" placeholder="Full Name (for verification)" required
                       class="w-full pl-10 pr-4 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl placeholder-indigo-300/50 focus:border-accent-indigo transition duration-200 shadow-inner">
            </div>
            
            <!-- Email -->
            <div class="relative">
                <i class="bi bi-envelope-fill form-input-icon"></i>
                <label for="email" class="sr-only">Email</label>
                <input type="Email" name="email" value="<?php echo $email; ?>" placeholder="Email Address" required
                       class="w-full pl-10 pr-4 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl placeholder-indigo-300/50 focus:border-accent-indigo transition duration-200 shadow-inner">
            </div>

            <!-- Country (Hidden but Displayed) -->
            <!-- CRITICAL: The country input is hidden and hardcoded to 'Nigeria' -->
            <input type="hidden" name="countryname" value="Nigeria">
            <div class="mb-4 text-sm text-indigo-300 p-4 bg-indigo-900/40 rounded-xl flex items-center shadow-md border border-indigo-700/50">
                <i class="bi bi-geo-alt-fill text-accent-indigo-light mr-3 text-lg"></i>
                Registration Country: <span class="font-bold text-white ml-2">Nigeria (Fixed)</span>
            </div>

            <!-- Package -->
            <div class="relative">
                 <i class="bi bi-star-fill form-input-icon"></i>
                <label for="plantype" class="sr-only">Package</label>
                <select name="plantype" id="plantype" required
                        class="w-full pl-10 pr-10 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl appearance-none cursor-pointer focus:border-accent-indigo transition duration-200 shadow-inner">
                    <option class="bg-card-purple" selected disabled>Select Package</option>
                    <!-- PHP logic preserved, only the style class changes -->
                    <option class="bg-card-purple" value="plan_a">UPPER PACKAGE</option>
                    <option class="bg-card-purple" value="plan_b">LOWER PACKAGR</option>
                </select>
                <i class="bi bi-caret-down-fill absolute right-3 top-1/2 transform -translate-y-1/2 text-indigo-400 pointer-events-none"></i>
            </div>
             
            <!-- Phone Number -->
            <div class="relative">
                <i class="bi bi-phone-fill form-input-icon"></i>
                <label for="phoneNumber" class="sr-only">Phone Number</label>
                <input type="number" name="phoneNumber" value="<?php echo $phone; ?>" placeholder="Enter phone number" required
                       class="w-full pl-10 pr-4 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl placeholder-indigo-300/50 focus:border-accent-indigo transition duration-200 shadow-inner">
            </div>

            <!-- Coupon Code -->
            <div class="relative">
                 <i class="bi bi-ticket-perforated-fill form-input-icon"></i>
                <label for="coupon" class="sr-only">Coupon Code</label>
                <input type="text" name="coupon" value="<?php echo $coupon; ?>" placeholder="Enter coupon code" required
                       class="w-full pl-10 pr-4 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl placeholder-indigo-300/50 focus:border-accent-indigo transition duration-200 shadow-inner">
                <a class="text-xs text-accent-indigo-light hover:text-accent-indigo mt-1 block text-right font-medium" href="vendor.php">
                    <i class="bi bi-bag-plus-fill mr-1"></i> Buy Coupon Code
                </a>
            </div>

            <!-- Referral ID -->
            <div class="relative">
                <i class="bi bi-person-check-fill form-input-icon"></i>
                <label for="refUsername" class="sr-only">Referral ID</label>
                <input type="text" name="refUsername" value="<?php echo $refUsername; ?>" placeholder="Referral ID (optional)"
                       class="w-full pl-10 pr-4 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl placeholder-indigo-300/50 focus:border-accent-indigo transition duration-200 shadow-inner">
            </div>

            <!-- Password -->
            <div class="relative">
                 <i class="bi bi-lock-fill form-input-icon"></i>
                <label for="password" class="sr-only">Password</label>
                <input type="password" name="password" id="password" placeholder="Create password" required
                       class="w-full pl-10 pr-10 py-3 bg-indigo-900/30 text-white border border-indigo-700/50 rounded-xl placeholder-indigo-300/50 focus:border-accent-indigo transition duration-200 shadow-inner">
                <span class="absolute right-3 top-1/2 transform -translate-y-1/2 text-indigo-400 cursor-pointer hover:text-white transition duration-200" onclick="togglePassword()">
                    <i id="password-toggle-icon" class="bi bi-eye-slash-fill"></i>
                </span>
            </div>

            <!-- Terms Checkbox -->
            <div class="flex items-start pt-2">
                <!-- Changed checkbox style to match accent color -->
                <input type="checkbox" name="terms" id="terms" required
                       class="mt-1 w-5 h-5 text-accent-indigo bg-indigo-900/30 border-indigo-700 rounded-lg focus:ring-accent-indigo checked:bg-accent-indigo">
                <label for="terms" class="ml-3 text-sm text-gray-400">
                    I have read and accept the <a class="text-accent-indigo-light hover:text-white font-bold transition duration-150" href="terms.php">terms & conditions</a>
                </label>
            </div>

            <!-- Submit Button (Dramatic Style) -->
            <button name="signup" type="submit" 
                    class="w-full py-4 bg-accent-indigo text-white font-extrabold text-lg rounded-xl shadow-lg shadow-indigo-500/50 hover:bg-indigo-600 transition duration-300 transform hover:scale-[1.01] focus:outline-none focus:ring-4 focus:ring-indigo-500/70 mt-8 uppercase tracking-wider">
                <i class="bi bi-lightning-charge-fill mr-2"></i> ACTIVATE ACCOUNT
            </button>
        </form>   
        
        <!-- Login Link -->
        <div class="mt-6 text-center text-gray-400 text-sm">
            <p>Already an Ultimate member? <a class="text-accent-indigo-light hover:text-white font-bold transition duration-150" href="login.php">Log In Here</a></p>
        </div>    
    </div>

    <!-- JavaScript for Password Toggle -->
    <script>
        function togglePassword() {
            const passField = document.getElementById("password");
            const toggleIcon = document.getElementById("password-toggle-icon");

            if (passField.type === "password") {
                passField.type = "text";
                toggleIcon.classList.remove('bi-eye-slash-fill');
                toggleIcon.classList.add('bi-eye-fill');
            } else {
                passField.type = "password";
                toggleIcon.classList.remove('bi-eye-fill');
                toggleIcon.classList.add('bi-eye-slash-fill');
            }
        }
    </script>
</body>
</html>