<?php 
error_reporting(E_ALL);
ini_set('display_errors', '1');

require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/actions/formprocess.php";

$ptitle = "Get Code";
include "inc/top.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Verified Coupon Vendors</title>
  
  <!-- Tailwind CSS CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Bootstrap Icons CDN -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    
  <script>
    tailwind.config = {
        theme: {
            extend: {
                fontFamily: {
                    sans: ['Inter', 'sans-serif'],
                },
                colors: {
                    // MODERN, TRUSTED THEME PALETTE (Deep Blue and Teal)
                    'bg-dark': '#0B172A',
                    'card-surface': '#1D2C42', 
                    'accent-teal': '#10B981', // Emerald 500
                    'text-light': '#F0FDF4',
                    'text-muted': '#94A3B8', // Slate 400
                }
            }
        }
    }
  </script>
  <style>
    /* Global styles for mobile-first design */
   /* body {
        /*background-color: #0B172A;*/
        color: #F0FDF4;
        min-height: 100vh;
        font-family: 'Inter', sans-serif;
        padding-bottom: 70px; /* Space for the footer/bottom nav */
    }
    .profile-img {
        object-fit: cover;
        width: 100%;
        height: 100%;
    }
    /* Touch feedback for cards */
    .vendor-card:active {
        transform: scale(0.99);
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.5);
    }
  </style>
</head>
<body>
<br><br>

  <div class="px-4 pt-10 pb-4 max-w-xl mx-auto">
    
    <!-- Header Section -->
    <div class="text-center mb-8">
        <i class="bi bi-patch-check-fill text-accent-teal text-4xl mb-2"></i>
        <h1 class="text-3xl font-extrabold text-text-light tracking-tight">Verified Coupon Vendors</h1>
        <p class="text-text-muted mt-2 text-sm">Contact any vendor below to securely purchase your coupon code.</p>
    </div>

    <!-- Vendor List -->
    <div class="space-y-4">
        <?php
        $sql = "SELECT * FROM users WHERE role = 'vendor'";
        $result = $link->query($sql);

        if ($result->num_rows > 0) {
            $users = [];
            while ($row = $result->fetch_assoc()) {
                $users[] = $row;
            }
            shuffle($users);

            foreach ($users as $user) {
                
                // Image Source Logic
                $image_src = ($user["image"] == "no-avatar.png") 
                             ? "structure.jpg" 
                             : "dash/assets/img/profilephotos/" . $user["image"];

                // WhatsApp Link Logic
                $whatsapp_link = 'https://wa.me/' . $user["phone"] . '?text=Hello+' . $user["username"] . ',+I+want+to+buy+ultimate+Coupon+code';
                
                echo '<div class="vendor-card bg-card-surface rounded-xl p-4 flex items-center justify-between shadow-lg border-b-2 border-accent-teal/50 transition duration-200">';
                
                // Left side: Profile Image & Username
                echo '<div class="flex items-center flex-grow">';
                
                // Profile Picture
                echo '<div class="w-12 h-12 rounded-full overflow-hidden mr-4 border-2 border-accent-teal/50 flex-shrink-0">';
                echo '<img class="profile-img" src="' . htmlspecialchars($image_src) . '" alt="' . htmlspecialchars($user["username"]) . ' profile">';
                echo '</div>';
                
                // Username
                echo '<div class="vendor-username text-lg font-bold text-text-light lowercase truncate">' . htmlspecialchars($user["username"]) . '</div>';
                
                echo '</div>'; // Close flex-grow container
                
                // Right side: CHAT Button
                echo '<a href="' . htmlspecialchars($whatsapp_link) . '" target="_blank" class="message-btn bg-accent-teal text-bg-dark font-bold py-2 px-4 rounded-lg shadow-md hover:bg-emerald-400 transition duration-150 flex items-center flex-shrink-0 ml-4">';
                echo '<i class="bi bi-whatsapp text-lg mr-2"></i> CHAT';
                echo '</a>';
                
                echo '</div>'; // Close vendor-card
            }
        } else {
            // No vendors found message
            echo '<div class="text-center p-8 bg-card-surface rounded-xl text-text-muted border border-accent-teal/30">';
            echo '<i class="bi bi-people-fill text-4xl mb-3 block"></i>';
            echo '<p class="font-semibold">Vendor list is currently empty. Check back shortly!</p>';
            echo '</div>';
        }
        ?>
    </div>
  </div>
  <br><br>

  <?php include "inc/buttom.php" ?>
</body>
</html>